/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CBCClientForge {
    public static void prepareClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        CBCBlockPartials.init();
        modEventBus.addListener(CBCClientForge::onClientSetup);
        modEventBus.addListener(CBCClientForge::onRegisterKeyMappings);
        modEventBus.addListener(CBCClientForge::onRegisterParticleFactories);
        modEventBus.addListener(CBCClientForge::onTextureStitchAtlasPre);
        forgeEventBus.addListener(CBCClientForge::getFogColor);
        forgeEventBus.addListener(CBCClientForge::getFogDensity);
        forgeEventBus.addListener(CBCClientForge::onClientGameTick);
        forgeEventBus.addListener(CBCClientForge::onScrollMouse);
        forgeEventBus.addListener(CBCClientForge::onFovModify);
        forgeEventBus.addListener(CBCClientForge::onPlayerRenderPre);
        forgeEventBus.addListener(CBCClientForge::onSetupCamera);
    }

    public static void onRegisterParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        CBCClientCommon.onRegisterParticleFactories(mc, mc.f_91061_);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CBCClientCommon.onClientSetup();
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        CBCClientCommon.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    public static void getFogColor(ViewportEvent.ComputeFogColor event) {
        CBCClientCommon.setFogColor(event.getCamera(), (r, g, b) -> {
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
        });
    }

    public static void getFogDensity(ViewportEvent.RenderFog event) {
        if (!event.isCancelable()) {
            return;
        }
        float density = CBCClientCommon.getFogDensity(event.getCamera(), event.getFarPlaneDistance());
        if (density != -1.0f) {
            event.setFarPlaneDistance(density);
            event.setNearPlaneDistance(density);
            event.setCanceled(true);
        }
    }

    public static void onClientGameTick(TickEvent.ClientTickEvent evt) {
        CBCClientCommon.onClientGameTick(Minecraft.m_91087_());
    }

    public static void onScrollMouse(InputEvent.MouseScrollingEvent evt) {
        if (CBCClientCommon.onScrollMouse(Minecraft.m_91087_(), evt.getScrollDelta()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onFovModify(ComputeFovModifierEvent evt) {
        evt.setNewFovModifier(CBCClientCommon.onFovModify(Minecraft.m_91087_(), evt.getNewFovModifier()));
    }

    public static void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        if (CBCClientCommon.onPlayerRenderPre(evt.getPoseStack(), (AbstractClientPlayer)evt.getEntity(), evt.getRenderer(), evt.getPartialTick()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onTextureStitchAtlasPre(TextureStitchEvent.Pre evt) {
        CBCClientCommon.onTextureAtlasStitchPre(arg_0 -> ((TextureStitchEvent.Pre)evt).addSprite(arg_0));
    }

    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles evt) {
        if (CBCClientCommon.onCameraSetup(evt.getCamera(), evt.getPartialTick(), evt.getYaw(), evt.getPitch(), evt.getRoll(), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0)) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }
}

