/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.munition_assembly;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.index.CBCRecipeTypes;
import rbasamoyai.createbigcannons.munitions.FuzedItemMunition;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonRoundItem;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class CartridgeAssemblyRecipe
extends CustomRecipe {
    public CartridgeAssemblyRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int i;
        int roundPosition = -1;
        int cartridgePosition = -1;
        boolean searchFuze = false;
        int fuzePosition = -1;
        for (int i2 = 0; i2 < container.m_6643_(); ++i2) {
            ItemStack stack = container.m_8020_(i2);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof AutocannonRoundItem) {
                if (roundPosition != -1) {
                    return false;
                }
                roundPosition = i2;
                if (!(stack.m_41720_() instanceof FuzedItemMunition)) continue;
                searchFuze = true;
                continue;
            }
            if (stack.m_41720_() == CBCItems.FILLED_AUTOCANNON_CARTRIDGE.get()) {
                if (cartridgePosition != -1) {
                    return false;
                }
                cartridgePosition = i2;
                continue;
            }
            if (stack.m_41720_() instanceof FuzeItem) {
                if (fuzePosition != -1) {
                    return false;
                }
                fuzePosition = i2;
                continue;
            }
            return false;
        }
        if (roundPosition == -1 || cartridgePosition == -1 || !searchFuze && fuzePosition != -1) {
            return false;
        }
        int w = container.m_39347_();
        return cartridgePosition % w == (i = roundPosition % w) && (fuzePosition == -1 || fuzePosition % w == i);
    }

    public ItemStack assemble(CraftingContainer container) {
        int i;
        int roundPosition = -1;
        int cartridgePosition = -1;
        boolean searchFuze = false;
        int fuzePosition = -1;
        for (int i2 = 0; i2 < container.m_6643_(); ++i2) {
            ItemStack stack = container.m_8020_(i2);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof AutocannonRoundItem) {
                if (roundPosition != -1) {
                    return ItemStack.f_41583_;
                }
                roundPosition = i2;
                if (!(stack.m_41720_() instanceof FuzedItemMunition)) continue;
                searchFuze = true;
                continue;
            }
            if (stack.m_41720_() == CBCItems.FILLED_AUTOCANNON_CARTRIDGE.get()) {
                if (cartridgePosition != -1) {
                    return ItemStack.f_41583_;
                }
                cartridgePosition = i2;
                continue;
            }
            if (stack.m_41720_() instanceof FuzeItem) {
                if (fuzePosition != -1) {
                    return ItemStack.f_41583_;
                }
                fuzePosition = i2;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (roundPosition == -1 || cartridgePosition == -1 || !searchFuze && fuzePosition != -1) {
            return ItemStack.f_41583_;
        }
        int w = container.m_39347_();
        if (cartridgePosition % w != (i = roundPosition % w) || fuzePosition != -1 && fuzePosition % w != i) {
            return ItemStack.f_41583_;
        }
        ItemStack result = CBCItems.AUTOCANNON_CARTRIDGE.asStack();
        CompoundTag tag = result.m_41784_();
        ItemStack roundCopy = container.m_8020_(roundPosition).m_41777_();
        roundCopy.m_41764_(1);
        if (fuzePosition != -1) {
            ItemStack fuzeCopy = container.m_8020_(fuzePosition).m_41777_();
            fuzeCopy.m_41764_(1);
            roundCopy.m_41784_().m_128365_("Fuze", (Tag)fuzeCopy.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("Projectile", (Tag)roundCopy.m_41739_(new CompoundTag()));
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return CBCRecipeTypes.CARTRIDGE_ASSEMBLY.getSerializer();
    }
}

