/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeIngredient;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;

public class BuiltUpHeatingRecipe
implements BlockRecipe {
    private final Set<BlockRecipeIngredient> layers;
    private final Block result;
    private final ResourceLocation id;
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public BuiltUpHeatingRecipe(Set<BlockRecipeIngredient> requiredLayers, Block result, ResourceLocation id) {
        this.layers = requiredLayers;
        this.result = result;
        this.id = id;
    }

    public Set<BlockRecipeIngredient> layers() {
        return this.layers;
    }

    public Block result() {
        return this.result;
    }

    @Override
    public boolean matches(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof LayeredBigCannonBlockEntity)) {
            return false;
        }
        LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity;
        if (layered.getLayers().size() != this.layers.size()) {
            return false;
        }
        HashSet<BlockRecipeIngredient> copy = new HashSet<BlockRecipeIngredient>(this.layers);
        for (Block block : layered.getLayers().values()) {
            Iterator iter = copy.iterator();
            while (iter.hasNext()) {
                BlockRecipeIngredient pred = (BlockRecipeIngredient)iter.next();
                if (!pred.test(block.m_49966_())) continue;
                iter.remove();
                break;
            }
            if (!copy.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assembleInWorld(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof LayeredBigCannonBlockEntity)) {
            return;
        }
        LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity;
        BlockState oldState = level.m_8055_(pos);
        if (!oldState.m_61138_((Property)FACING)) {
            return;
        }
        layered.m_7651_();
        BlockState state = this.result.m_49966_();
        if (state.m_61138_((Property)FACING)) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)oldState.m_61143_((Property)FACING)));
        }
        level.m_7731_(pos, state, 11);
        level.m_5594_(null, pos, SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 2.0f);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (!(blockEntity2 instanceof IBigCannonBlockEntity)) {
            return;
        }
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity2;
        BigCannonBlock.onPlace(level, pos);
    }

    @Override
    public Block getResultBlock() {
        return this.result;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public BlockRecipeSerializer<?> getSerializer() {
        return BlockRecipeSerializer.BUILT_UP_HEATING;
    }

    @Override
    public BlockRecipeType<?> getType() {
        return BlockRecipeType.BUILT_UP_HEATING;
    }

    public static class Serializer
    implements BlockRecipeSerializer<BuiltUpHeatingRecipe> {
        @Override
        public BuiltUpHeatingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            JsonArray layerArr = obj.getAsJsonArray("layers");
            HashSet<BlockRecipeIngredient> layers = new HashSet<BlockRecipeIngredient>();
            if (layerArr != null) {
                for (JsonElement el : layerArr) {
                    layers.add(BlockRecipeIngredient.fromJson(el));
                }
            }
            Block result = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(obj.get("result").getAsString()));
            return new BuiltUpHeatingRecipe(layers, result, id);
        }

        @Override
        public BuiltUpHeatingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int sz = buf.m_130242_();
            HashSet<BlockRecipeIngredient> layers = sz == 0 ? null : new HashSet<BlockRecipeIngredient>();
            for (int i = 0; i < sz; ++i) {
                layers.add(BlockRecipeIngredient.fromNetwork(buf));
            }
            Block result = (Block)Registry.f_122824_.m_7745_(buf.m_130281_());
            return new BuiltUpHeatingRecipe(layers, result, id);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, BuiltUpHeatingRecipe recipe) {
            buf.m_130130_(recipe.layers == null ? 0 : recipe.layers.size());
            if (recipe.layers != null && !recipe.layers.isEmpty()) {
                recipe.layers.forEach(p -> p.toNetwork(buf));
            }
            buf.m_130085_(Registry.f_122824_.m_7981_((Object)recipe.result));
        }
    }
}

