/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;

public class BlockRecipesManager {
    private static final Map<ResourceLocation, BlockRecipe> BLOCK_RECIPES_BY_NAME = new HashMap<ResourceLocation, BlockRecipe>();
    private static final Map<BlockRecipeType<?>, Map<ResourceLocation, BlockRecipe>> BLOCK_RECIPES_BY_TYPE = new HashMap();

    public static Collection<BlockRecipe> getRecipes() {
        return BLOCK_RECIPES_BY_NAME.values();
    }

    public static Collection<BlockRecipe> getRecipesOfType(BlockRecipeType<?> type) {
        return ((Map)BLOCK_RECIPES_BY_TYPE.getOrDefault(type, new HashMap())).values();
    }

    public static void clear() {
        BLOCK_RECIPES_BY_NAME.clear();
        BLOCK_RECIPES_BY_TYPE.clear();
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(BLOCK_RECIPES_BY_NAME.size());
        for (Map.Entry<ResourceLocation, BlockRecipe> entry : BLOCK_RECIPES_BY_NAME.entrySet()) {
            buf.m_130085_(entry.getKey());
            BlockRecipesManager.toNetworkCasted(buf, entry.getValue());
        }
    }

    public static <T extends BlockRecipe> void toNetworkCasted(FriendlyByteBuf buf, T recipe) {
        BlockRecipeSerializer<?> ser = recipe.getSerializer();
        buf.m_130085_(CBCRegistries.BLOCK_RECIPE_SERIALIZERS.m_7981_(ser));
        ser.toNetwork(buf, recipe);
    }

    public static void readBuf(FriendlyByteBuf buf) {
        BlockRecipesManager.clear();
        int sz = buf.m_130242_();
        for (int i = 0; i < sz; ++i) {
            ResourceLocation id = buf.m_130281_();
            ResourceLocation type = buf.m_130281_();
            Object recipe = ((BlockRecipeSerializer)CBCRegistries.BLOCK_RECIPE_SERIALIZERS.m_7745_(type)).fromNetwork(id, buf);
            BLOCK_RECIPES_BY_NAME.put(id, (BlockRecipe)recipe);
            BlockRecipeType recipeType = (BlockRecipeType)CBCRegistries.BLOCK_RECIPE_TYPES.m_7745_(type);
            if (!BLOCK_RECIPES_BY_TYPE.containsKey(recipeType)) {
                BLOCK_RECIPES_BY_TYPE.put(recipeType, new HashMap());
            }
            BLOCK_RECIPES_BY_TYPE.get(recipeType).put(id, (BlockRecipe)recipe);
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundRecipesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundRecipesPacket(), server);
    }

    public static class ClientboundRecipesPacket
    implements RootPacket {
        private FriendlyByteBuf buf;

        public ClientboundRecipesPacket() {
        }

        public ClientboundRecipesPacket(FriendlyByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            BlockRecipesManager.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            BlockRecipesManager.readBuf(this.buf);
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "block_recipes");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resources, ProfilerFiller profiler) {
            BlockRecipesManager.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                ResourceLocation id = entry.getKey();
                JsonObject obj = el.getAsJsonObject();
                ResourceLocation type = new ResourceLocation(obj.get("type").getAsString());
                Object recipe = ((BlockRecipeSerializer)CBCRegistries.BLOCK_RECIPE_SERIALIZERS.m_7745_(type)).fromJson(id, obj);
                BLOCK_RECIPES_BY_NAME.put(id, (BlockRecipe)recipe);
                BlockRecipeType recipeType = (BlockRecipeType)CBCRegistries.BLOCK_RECIPE_TYPES.m_7745_(type);
                if (!BLOCK_RECIPES_BY_TYPE.containsKey(recipeType)) {
                    BLOCK_RECIPES_BY_TYPE.put(recipeType, new HashMap());
                }
                BLOCK_RECIPES_BY_TYPE.get(recipeType).put(id, (BlockRecipe)recipe);
            }
        }
    }
}

