/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;

public record BigCannonMaterialProperties(int squibRatioNum, int squibRatioDem, float weight, int maxSafeBaseCharges, FailureMode failureMode) {
    public double squibRatio() {
        return this.squibRatioDem == 0 ? 0.0 : (double)this.squibRatioNum / (double)this.squibRatioDem;
    }

    public static BigCannonMaterialProperties fromJson(JsonObject obj) {
        int squibRatioNum = Math.max(0, GsonHelper.m_13927_((JsonObject)obj, (String)"squib_ratio_barrels"));
        int squibRatioDem = Math.max(1, GsonHelper.m_13927_((JsonObject)obj, (String)"squib_ratio_propellant"));
        float weight = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"weight", (float)2.0f));
        int maxSafeBaseCharges = Math.max(0, GsonHelper.m_13824_((JsonObject)obj, (String)"max_safe_charges", (int)2));
        FailureMode failureMode = FailureMode.byId(GsonHelper.m_13906_((JsonObject)obj, (String)"failure_mode"));
        return new BigCannonMaterialProperties(squibRatioNum, squibRatioDem, weight, maxSafeBaseCharges, failureMode);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("squib_ratio_barrels", (Number)this.squibRatioNum);
        obj.addProperty("squib_ratio_propellant", (Number)this.squibRatioDem);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("max_safe_charges", (Number)this.maxSafeBaseCharges);
        obj.addProperty("failure_mode", this.failureMode.toString());
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.squibRatioNum).m_130130_(this.squibRatioDem).writeFloat(this.weight);
        buf.m_130130_(this.maxSafeBaseCharges).m_130130_(this.failureMode.ordinal());
    }

    public static BigCannonMaterialProperties fromBuf(FriendlyByteBuf buf) {
        int squibRatioNum = buf.m_130242_();
        int squibRatioDem = buf.m_130242_();
        float weight = buf.readFloat();
        int maxSafeBaseCharges = buf.m_130242_();
        FailureMode mode = FailureMode.values()[buf.m_130242_()];
        return new BigCannonMaterialProperties(squibRatioNum, squibRatioDem, weight, maxSafeBaseCharges, mode);
    }

    public static enum FailureMode implements StringRepresentable
    {
        RUPTURE,
        FRAGMENT;

        private static final Map<String, FailureMode> BY_ID;
        private final String name = this.name().toLowerCase();

        public String m_7912_() {
            return this.name;
        }

        public static FailureMode byId(String id) {
            return BY_ID.getOrDefault(id, RUPTURE);
        }

        static {
            BY_ID = Arrays.stream(FailureMode.values()).collect(Collectors.toMap(StringRepresentable::m_7912_, Function.identity()));
        }
    }
}

