/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import rbasamoyai.createbigcannons.base.PartialBlockDamageSaveData;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public class PartialBlockDamageManager {
    private Map<ResourceKey<Level>, Map<BlockPos, Integer>> blockDamage;
    private PartialBlockDamageSaveData savedata;

    public PartialBlockDamageManager() {
        this.cleanUp();
    }

    public void playerLogin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            this.loadDamageData(splayer.m_20194_());
        }
    }

    public void playerLogout(Player player) {
    }

    public void levelLoaded(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        this.cleanUp();
        this.savedata = null;
        this.loadDamageData(server);
    }

    private void cleanUp() {
        this.blockDamage = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();
    }

    private void loadDamageData(MinecraftServer server) {
        if (this.savedata != null) {
            return;
        }
        this.savedata = PartialBlockDamageSaveData.load(server);
        this.blockDamage = this.savedata.getBlockDamage();
    }

    public void tick(Level level) {
        ResourceKey dimension = level.m_46472_();
        if (!this.blockDamage.containsKey(dimension)) {
            return;
        }
        Map<BlockPos, Integer> levelSet = this.blockDamage.get(dimension);
        if (levelSet.isEmpty()) {
            this.blockDamage.remove(dimension);
            return;
        }
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        HashMap<BlockPos, Integer> newSet = new HashMap<BlockPos, Integer>();
        Iterator<Map.Entry<BlockPos, Integer>> iter = levelSet.entrySet().iterator();
        while (iter.hasNext()) {
            int newPart;
            double hardnessRec;
            int oldPart;
            Map.Entry<BlockPos, Integer> entry = iter.next();
            BlockPos pos = entry.getKey();
            BlockState state = level.m_46745_(pos).m_8055_(pos);
            Material mat = state.m_60767_();
            int oldProgress = entry.getValue();
            if (mat.m_76336_() || !mat.m_76333_() || state.m_60800_((BlockGetter)level, pos) == -1.0f) {
                if (oldProgress > 0) {
                    level.m_6801_(-1, pos, -1);
                }
                iter.remove();
                continue;
            }
            int newProgress = oldProgress - 3;
            if (newProgress <= 0) {
                level.m_6801_(-1, pos, -1);
                iter.remove();
            } else {
                newSet.put(entry.getKey(), newProgress);
            }
            if ((oldPart = (int)Math.floor((double)oldProgress * (hardnessRec = 1.0 / BlockHardnessHandler.getHardness(state)))) - (newPart = (int)Math.floor((double)newProgress * hardnessRec)) <= 0) continue;
            level.m_6801_(-1, pos, newPart);
        }
        levelSet.putAll(newSet);
        this.markDirty();
    }

    public void markDirty() {
        if (this.savedata != null) {
            this.savedata.m_77762_();
        }
    }

    public void damageBlock(BlockPos pos, int added, BlockState state, Level level) {
        Map levelSet = this.blockDamage.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new HashMap());
        int oldProgress = levelSet.getOrDefault(pos, 0);
        levelSet.merge(pos, added, Integer::sum);
        double hardnessRec = 1.0 / BlockHardnessHandler.getHardness(state);
        int oldPart = (int)Math.floor((double)oldProgress * hardnessRec);
        int newPart = (int)Math.floor((double)((Integer)levelSet.get(pos)).intValue() * hardnessRec);
        if (newPart >= 10) {
            if (!level.m_5776_()) {
                level.m_46961_(pos, false);
            }
            levelSet.remove(pos);
        } else if (newPart - oldPart > 0) {
            level.m_6801_(-1, pos, newPart);
        }
        this.markDirty();
    }
}

