/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCFluids;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;
import rbasamoyai.createbigcannons.index.fluid_utils.CBCFlowingFluid;
import rbasamoyai.createbigcannons.mixin.client.CameraAccessor;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.network.ServerboundFiringActionPacket;
import rbasamoyai.createbigcannons.network.ServerboundSetFireRatePacket;
import rbasamoyai.createbigcannons.ponder.CBCPonderIndex;

public class CBCClientCommon {
    private static final String KEY_ROOT = "key.createbigcannons";
    public static final KeyMapping PITCH_MODE = IndexPlatform.createSafeKeyMapping("key.createbigcannons.pitch_mode", InputConstants.Type.KEYSYM, 67);
    public static final KeyMapping FIRE_CONTROLLED_CANNON = IndexPlatform.createSafeKeyMapping("key.createbigcannons.fire_controlled_cannon", InputConstants.Type.MOUSE, 0);
    public static final List<KeyMapping> KEYS = new ArrayList<KeyMapping>();

    public static void onRegisterParticleFactories(Minecraft mc, ParticleEngine engine) {
        CBCParticleTypes.registerFactories();
    }

    public static void onClientSetup() {
        CBCPonderIndex.register();
        CBCPonderIndex.registerTags();
        CBCBlockPartials.resolveDeferredModels();
        IndexPlatform.registerClampedItemProperty((Item)CBCItems.PARTIALLY_FORMED_AUTOCANNON_CARTRIDGE.get(), CreateBigCannons.resource("formed"), (stack, level, player, a) -> stack.m_41784_().m_128469_("SequencedAssembly").m_128451_("Step") - 1);
        IndexPlatform.registerClampedItemProperty((Item)CBCItems.PARTIALLY_FORMED_BIG_CARTRIDGE.get(), CreateBigCannons.resource("formed"), (stack, level, player, a) -> stack.m_41784_().m_128469_("SequencedAssembly").m_128451_("Step") - 1);
        IndexPlatform.registerClampedItemProperty(((BigCartridgeBlock)CBCBlocks.BIG_CARTRIDGE.get()).m_5456_(), CreateBigCannons.resource("big_cartridge_filled"), (stack, level, player, a) -> BigCartridgeBlockItem.getPower(stack));
    }

    public static void registerKeyMappings(Consumer<KeyMapping> cons) {
        cons.accept(PITCH_MODE);
        cons.accept(FIRE_CONTROLLED_CANNON);
        KEYS.add(PITCH_MODE);
        KEYS.add(FIRE_CONTROLLED_CANNON);
    }

    public static void setFogColor(Camera info, SetColorWrapper wrapper) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidState = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidState.m_76152_();
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_CAST_IRON.get())).m_6212_(fluid)) {
            wrapper.setFogColor(0.27450982f, 0.039215688f, 0.043137256f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_BRONZE.get())).m_6212_(fluid)) {
            wrapper.setFogColor(0.3882353f, 0.25882354f, 0.08627451f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_STEEL.get())).m_6212_(fluid)) {
            wrapper.setFogColor(0.43529412f, 0.43137255f, 0.41568628f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_NETHERSTEEL.get())).m_6212_(fluid)) {
            wrapper.setFogColor(0.29803923f, 0.19607843f, 0.22745098f);
            return;
        }
    }

    public static float getFogDensity(Camera info, float currentDensity) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidState = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)level, blockPos))) {
            return -1.0f;
        }
        Fluid fluid = fluidState.m_76152_();
        List<Fluid> moltenMetals = Arrays.asList((Fluid)CBCFluids.MOLTEN_CAST_IRON.get(), (Fluid)CBCFluids.MOLTEN_BRONZE.get(), (Fluid)CBCFluids.MOLTEN_STEEL.get(), (Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get());
        for (Fluid fluid1 : moltenMetals) {
            if (!fluid1.m_6212_(fluid)) continue;
            return 0.03125f;
        }
        return -1.0f;
    }

    public static void onClientGameTick(Minecraft mc) {
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91074_.m_20201_();
        if (entity instanceof CannonCarriageEntity) {
            CannonCarriageEntity carriage = (CannonCarriageEntity)entity;
            Input input = mc.f_91074_.f_108618_;
            boolean isPitching = PITCH_MODE.m_90857_();
            carriage.setInput(input.f_108570_, input.f_108571_, input.f_108568_, input.f_108569_, isPitching);
            mc.f_91074_.f_108611_ |= input.f_108570_ | input.f_108571_ | input.f_108568_ | input.f_108569_;
        }
        if (FIRE_CONTROLLED_CANNON.m_90857_() && CBCClientCommon.isControllingCannon((Entity)mc.f_91074_)) {
            mc.f_91074_.f_108611_ = true;
            NetworkPlatform.sendToServer(new ServerboundFiringActionPacket());
        }
    }

    public static boolean onScrollMouse(Minecraft mc, double delta) {
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return false;
        }
        if (mc.f_91074_.m_20201_() instanceof CannonCarriageEntity) {
            int fireRateAdjustment = 0;
            if (delta > 0.0) {
                fireRateAdjustment = 1;
            } else if (delta < 0.0) {
                fireRateAdjustment = -1;
            }
            if (fireRateAdjustment != 0) {
                mc.f_91074_.f_108611_ = true;
                NetworkPlatform.sendToServer(new ServerboundSetFireRatePacket(fireRateAdjustment));
                return true;
            }
        }
        return false;
    }

    public static float onFovModify(Minecraft mc, float oldFov) {
        if (mc.f_91074_ == null || !mc.f_91066_.m_92176_().m_90612_()) {
            return CBCClientCommon.lerpFov(mc, oldFov);
        }
        return CBCClientCommon.lerpFov(mc, mc.f_91066_.f_92095_.m_90857_() && CBCClientCommon.isControllingCannon((Entity)mc.f_91074_) ? oldFov * 0.5f : oldFov);
    }

    private static float lerpFov(Minecraft mc, float fov) {
        return Mth.m_14179_((float)((Double)mc.f_91066_.m_231925_().m_231551_()).floatValue(), (float)1.0f, (float)fov);
    }

    public static boolean onPlayerRenderPre(PoseStack stack, AbstractClientPlayer player, PlayerRenderer renderer, float partialTicks) {
        PitchOrientedContraptionEntity poce;
        Entity entity = player.m_20202_();
        if (entity instanceof PitchOrientedContraptionEntity && (poce = (PitchOrientedContraptionEntity)entity).getSeatPos((Entity)player) != null) {
            float yr = (-Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) + 90.0f) * ((float)Math.PI / 180);
            Vector3f vec3 = new Vector3f(Mth.m_14031_((float)yr), 0.0f, Mth.m_14089_((float)yr));
            float xr = Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
            Quaternion q = vec3.m_122240_(xr);
            stack.m_85845_(q);
        }
        return false;
    }

    private static boolean isControllingCannon(Entity entity) {
        Entity vehicle = entity.m_20202_();
        return vehicle instanceof CannonCarriageEntity || vehicle instanceof PitchOrientedContraptionEntity;
    }

    public static Direction.Axis getRotationAxis(BlockState state) {
        boolean flag = (Boolean)state.m_61143_((Property)QuickfiringBreechBlock.AXIS);
        return switch (((Direction)state.m_61143_((Property)QuickfiringBreechBlock.f_52588_)).m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (flag) {
                    yield Direction.Axis.Y;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                if (flag) {
                    yield Direction.Axis.X;
                }
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> flag ? Direction.Axis.X : Direction.Axis.Y;
        };
    }

    public static PartialModel getBreechblockForState(BlockState state) {
        PartialModel partialModel;
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            partialModel = CBCBlockPartials.breechblockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_SLIDING_BREECHBLOCK;
        }
        return partialModel;
    }

    public static PartialModel getScrewBreechForState(BlockState state) {
        PartialModel partialModel;
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            partialModel = CBCBlockPartials.screwLockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.STEEL_SCREW_LOCK;
        }
        return partialModel;
    }

    public static void onTextureAtlasStitchPre(Consumer<ResourceLocation> cons) {
        cons.accept(CreateBigCannons.resource("item/tracer_slot"));
    }

    public static boolean onCameraSetup(Camera camera, double partialTicks, float yaw, float pitch, float roll, Consumer<Float> setYaw, Consumer<Float> setPitch, Consumer<Float> setRoll) {
        PitchOrientedContraptionEntity poce;
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || camera.m_90592_() != player || !((entity = player.m_20202_()) instanceof PitchOrientedContraptionEntity) || (poce = (PitchOrientedContraptionEntity)entity).getSeatPos((Entity)player) == null) {
            return false;
        }
        CameraAccessor camAccess = (CameraAccessor)camera;
        Direction dir = poce.getInitialOrientation();
        Vec3 normal = new Vec3(dir.m_122432_());
        Direction up = Direction.UP;
        Vec3 upNormal = new Vec3(up.m_122432_());
        Vec3 localPos = Vec3.m_82512_((Vec3i)poce.getSeatPos((Entity)player));
        if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            localPos = localPos.m_82549_(upNormal.m_82490_(0.35));
            Vec3 camPos = poce.toGlobalVector(localPos, (float)partialTicks);
            camAccess.callSetPosition(camPos);
        } else {
            camAccess.callSetPosition(camera.m_90583_().m_82549_(poce.applyRotation(upNormal.m_82490_(1.25), (float)partialTicks)));
        }
        boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
        boolean flag1 = mc.f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT;
        float sgn = flag1 ? -1.0f : 1.0f;
        float add = flag1 ? 180.0f : 0.0f;
        setYaw.accept(Float.valueOf(poce.yaw + add));
        setPitch.accept(Float.valueOf((flag ? -poce.pitch : poce.pitch) * sgn));
        setRoll.accept(Float.valueOf(0.0f));
        return true;
    }

    public static interface SetColorWrapper {
        public void setFogColor(float var1, float var2, float var3);
    }
}

