/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class ThinLogBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumMap<Direction.Axis, VoxelShape> SHAPES = VoxelShapeHelper.rotateAxis((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    private static final VoxelShape CONNECT_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    public static final EnumMap<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (EnumMap)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });

    public ThinLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.m_152458_(this::calculateShape);
    }

    private VoxelShape calculateShape(BlockState state) {
        ArrayList<VoxelShape> connectedSides = new ArrayList<VoxelShape>();
        for (Direction direction : Direction.values()) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
            if (axis == direction.m_122434_() || !((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(ThinLogBlock.getRotatedDirection(direction, axis)))).booleanValue()) continue;
            connectedSides.add(VoxelShapeHelper.rotateShape((VoxelShape)CONNECT_SHAPE, (Direction)direction));
        }
        return Shapes.m_83124_((VoxelShape)SHAPES.get(state.m_61143_((Property)f_55923_)), (VoxelShape[])connectedSides.toArray(new VoxelShape[0]));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = Objects.requireNonNull(super.m_5573_(context));
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        for (Direction direction : Direction.values()) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
            if (axis == direction.m_122434_()) continue;
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(ThinLogBlock.getRotatedDirection(direction, axis)), (Comparable)Boolean.valueOf(this.shouldConnect(state, context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction)))));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction.m_122434_() == axis) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(ThinLogBlock.getRotatedDirection(direction, axis)), (Comparable)Boolean.valueOf(this.shouldConnect(state, neighborState)));
    }

    private boolean shouldConnect(BlockState state, BlockState neighborState) {
        return neighborState.m_60734_() instanceof ThinLogBlock && state.m_61143_((Property)f_55923_) != neighborState.m_61143_((Property)f_55923_);
    }

    public static Direction getRotatedDirection(Direction direction, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return switch (direction) {
                case Direction.UP -> Direction.EAST;
                case Direction.DOWN -> Direction.WEST;
                default -> direction;
            };
        }
        if (axis == Direction.Axis.Z) {
            return switch (direction) {
                case Direction.UP -> Direction.NORTH;
                case Direction.DOWN -> Direction.SOUTH;
                default -> direction;
            };
        }
        return direction;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55923_, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

