/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.RoseQuartzUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class LargeRoseQuartzFeature
extends Feature<LargeDripstoneConfiguration> {
    public LargeRoseQuartzFeature(Codec<LargeDripstoneConfiguration> p_159960_) {
        super(p_159960_);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeDripstoneConfiguration> p_159967_) {
        WorldGenLevel worldgenlevel = p_159967_.m_159774_();
        BlockPos blockpos = p_159967_.m_159777_();
        LargeDripstoneConfiguration largedripstoneconfiguration = (LargeDripstoneConfiguration)p_159967_.m_159778_();
        RandomSource random = p_159967_.m_225041_();
        if (!RoseQuartzUtils.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.m_158175_((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)largedripstoneconfiguration.f_160945_, RoseQuartzUtils::isEmptyOrWater, RoseQuartzUtils::isRoseQuartzBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof Column.Range) {
            Column.Range column$range = (Column.Range)optional.get();
            if (column$range.m_158214_() < 4) {
                return false;
            }
            int i = (int)((float)column$range.m_158214_() * largedripstoneconfiguration.f_160948_);
            int j = Mth.m_14045_((int)i, (int)largedripstoneconfiguration.f_160946_.m_142739_(), (int)largedripstoneconfiguration.f_160946_.m_142737_());
            int k = Mth.m_216287_((RandomSource)random, (int)largedripstoneconfiguration.f_160946_.m_142739_(), (int)j);
            LargeRoseQuartz largedripstonefeature$largedripstone = LargeRoseQuartzFeature.makeRoseQuartz(blockpos.m_175288_(column$range.m_158212_() - 1), false, random, k, largedripstoneconfiguration.f_160949_, largedripstoneconfiguration.f_160947_);
            LargeRoseQuartz largedripstonefeature$largedripstone1 = LargeRoseQuartzFeature.makeRoseQuartz(blockpos.m_175288_(column$range.m_158213_() + 1), true, random, k, largedripstoneconfiguration.f_160950_, largedripstoneconfiguration.f_160947_);
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.m_123342_(), random, largedripstoneconfiguration.f_160951_) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeRoseQuartz makeRoseQuartz(BlockPos p_159969_, boolean p_159970_, RandomSource p_159971_, int p_159972_, FloatProvider p_159973_, FloatProvider p_159974_) {
        return new LargeRoseQuartz(p_159969_, p_159970_, p_159972_, p_159973_.m_214084_(p_159971_), p_159974_.m_214084_(p_159971_));
    }

    static final class LargeRoseQuartz {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeRoseQuartz(BlockPos p_159981_, boolean p_159982_, int p_159983_, double p_159984_, double p_159985_) {
            this.root = p_159981_;
            this.pointingUp = p_159982_;
            this.radius = p_159983_;
            this.bluntness = p_159984_;
            this.scale = p_159985_;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel p_159990_, WindOffsetter p_159991_) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_122032_();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (p_159990_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (RoseQuartzUtils.isCircleMostlyEmbeddedInStone(p_159990_, p_159991_.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float p_159988_) {
            return (int)RoseQuartzUtils.getRoseQuartzHeight(p_159988_, this.radius, this.scale, this.bluntness);
        }

        /*
         * Enabled aggressive block sorting
         */
        void placeBlocks(WorldGenLevel p_159993_, RandomSource p_159994_, WindOffsetter p_159995_) {
            int i = -this.radius;
            block5: while (i <= this.radius) {
                int j = -this.radius;
                while (true) {
                    block13: {
                        boolean flag;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos;
                        int k;
                        block14: {
                            block12: {
                                if (j > this.radius) break block12;
                                float f = Mth.m_14116_((float)(i * i + j * j));
                                if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) break block13;
                                if ((double)p_159994_.m_188501_() < 0.2) {
                                    k = (int)((float)k * Mth.m_216283_((RandomSource)p_159994_, (float)0.8f, (float)1.0f));
                                }
                                blockpos$mutableblockpos = this.root.m_7918_(i, 0, j).m_122032_();
                                flag = false;
                                break block14;
                            }
                            ++i;
                            continue block5;
                        }
                        for (int l = 0; l < k; ++l) {
                            block17: {
                                int n;
                                Direction[] directionArray;
                                BlockPos blockpos;
                                block16: {
                                    block15: {
                                        blockpos = p_159995_.offset((BlockPos)blockpos$mutableblockpos);
                                        if (!RoseQuartzUtils.isEmptyOrWaterOrLava((LevelAccessor)p_159993_, blockpos) && p_159993_.m_8055_(blockpos).m_60767_() != Material.f_164531_) break block15;
                                        flag = true;
                                        Block block = (Block)BOPBlocks.ROSE_QUARTZ_BLOCK.get();
                                        p_159993_.m_7731_(blockpos, block.m_49966_(), 2);
                                        directionArray = Direction.values();
                                        n = directionArray.length;
                                        break block16;
                                    }
                                    if (flag && p_159993_.m_8055_(blockpos).m_60713_(Blocks.f_50134_)) {
                                        break;
                                    }
                                    break block17;
                                }
                                for (int i2 = 0; i2 < n; ++i2) {
                                    Direction direction = directionArray[i2];
                                    if (p_159994_.m_188503_(4) != 0) continue;
                                    BlockState state = (BlockState)(switch (p_159994_.m_188503_(6)) {
                                        case 3 -> ((Block)BOPBlocks.ROSE_QUARTZ_CLUSTER.get()).m_49966_();
                                        default -> ((Block)BOPBlocks.LARGE_ROSE_QUARTZ_BUD.get()).m_49966_();
                                        case 1 -> ((Block)BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD.get()).m_49966_();
                                        case 0 -> ((Block)BOPBlocks.SMALL_ROSE_QUARTZ_BUD.get()).m_49966_();
                                    }).m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)direction);
                                    if (!p_159993_.m_8055_(blockpos.m_121945_(direction)).m_60795_() || !state.m_60710_((LevelReader)p_159993_, blockpos.m_121945_(direction))) continue;
                                    p_159993_.m_7731_(blockpos.m_121945_(direction), state, 2);
                                }
                            }
                            blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                        }
                    }
                    ++j;
                }
                break;
            }
            return;
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration p_159997_) {
            return this.radius >= p_159997_.f_160952_ && this.bluntness >= (double)p_159997_.f_160953_;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int p_160004_, RandomSource p_160005_, FloatProvider p_160006_) {
            this.originY = p_160004_;
            float f = p_160006_.m_214084_(p_160005_);
            float f1 = Mth.m_216283_((RandomSource)p_160005_, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)f1) * f), 0.0, (double)(Mth.m_14031_((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos p_160009_) {
            if (this.windSpeed == null) {
                return p_160009_;
            }
            int i = this.originY - p_160009_.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)i);
            return p_160009_.m_7637_(vec3.f_82479_, 0.0, vec3.f_82481_);
        }
    }
}

