/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class TurtleInventoryCrafting
extends CraftingContainer {
    private final ITurtleAccess turtle;
    private int xStart = 0;
    private int yStart = 0;

    public TurtleInventoryCrafting(ITurtleAccess turtle) {
        super(null, 0, 0);
        this.turtle = turtle;
    }

    @Nullable
    private Recipe<CraftingContainer> tryCrafting(int xStart, int yStart) {
        this.xStart = xStart;
        this.yStart = yStart;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= this.xStart && x < this.xStart + 3 && y >= this.yStart && y < this.yStart + 3 || this.turtle.getInventory().m_8020_(x + y * 4).m_41619_()) continue;
                return null;
            }
        }
        return this.turtle.getLevel().m_7465_().m_44015_(RecipeType.f_44107_, (Container)this, this.turtle.getLevel()).orElse(null);
    }

    @Nullable
    public List<ItemStack> doCrafting(Level world, int maxCount) {
        ItemStack result;
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        Recipe<CraftingContainer> recipe = this.tryCrafting(0, 0);
        if (recipe == null) {
            recipe = this.tryCrafting(0, 1);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 0);
        }
        if (recipe == null) {
            recipe = this.tryCrafting(1, 1);
        }
        if (recipe == null) {
            return null;
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        TurtlePlayer player = TurtlePlayer.get(this.turtle);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < maxCount && recipe.m_5818_((Container)this, world) && !(result = recipe.m_5874_((Container)this)).m_41619_(); ++i) {
            results.add(result);
            result.m_41678_(world, (Player)player, result.m_41613_());
            ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)result, (Container)this);
            ForgeHooks.setCraftingPlayer((Player)player);
            NonNullList remainders = recipe.m_7457_((Container)this);
            ForgeHooks.setCraftingPlayer(null);
            for (int slot = 0; slot < remainders.size(); ++slot) {
                ItemStack existing = this.m_8020_(slot);
                ItemStack remainder = (ItemStack)remainders.get(slot);
                if (!existing.m_41619_()) {
                    this.m_7407_(slot, 1);
                    existing = this.m_8020_(slot);
                }
                if (remainder.m_41619_()) continue;
                if (existing.m_41619_()) {
                    this.m_6836_(slot, remainder);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)existing, (ItemStack)remainder) && ItemStack.m_41658_((ItemStack)existing, (ItemStack)remainder)) {
                    remainder.m_41769_(existing.m_41613_());
                    this.m_6836_(slot, remainder);
                    continue;
                }
                results.add(remainder);
            }
        }
        return results;
    }

    public int m_39347_() {
        return 3;
    }

    public int m_39346_() {
        return 3;
    }

    private int modifyIndex(int index) {
        int x = this.xStart + index % this.m_39347_();
        int y = this.yStart + index / this.m_39346_();
        return x >= 0 && x < 4 && y >= 0 && y < 4 ? x + y * 4 : -1;
    }

    public int m_6643_() {
        return this.m_39347_() * this.m_39346_();
    }

    @Nonnull
    public ItemStack m_8020_(int i) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().m_8020_(i);
    }

    @Nonnull
    public ItemStack m_8016_(int i) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().m_8016_(i);
    }

    @Nonnull
    public ItemStack m_7407_(int i, int size) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().m_7407_(i, size);
    }

    public void m_6836_(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        this.turtle.getInventory().m_6836_(i, stack);
    }

    public int m_6893_() {
        return this.turtle.getInventory().m_6893_();
    }

    public void m_6596_() {
        this.turtle.getInventory().m_6596_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    public boolean m_7013_(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        return this.turtle.getInventory().m_7013_(i, stack);
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            int j = this.modifyIndex(i);
            this.turtle.getInventory().m_6836_(j, ItemStack.f_41583_);
        }
    }
}

