/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class TurtleSuckCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        Direction side;
        BlockPos turtlePosition;
        BlockPos blockPosition;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        Level world = turtle.getLevel();
        IItemHandler inventory = InventoryUtil.getInventory(world, blockPosition = (turtlePosition = turtle.getPosition()).m_121945_(direction), side = direction.m_122424_());
        if (inventory != null) {
            ItemStack stack = InventoryUtil.takeItems(this.quantity, inventory);
            if (stack.m_41619_()) {
                return TurtleCommandResult.failure("No items to take");
            }
            ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            if (!remainder.m_41619_()) {
                InventoryUtil.storeItems(remainder, inventory);
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        AABB aabb = new AABB((double)blockPosition.m_123341_(), (double)blockPosition.m_123342_(), (double)blockPosition.m_123343_(), (double)blockPosition.m_123341_() + 1.0, (double)blockPosition.m_123342_() + 1.0, (double)blockPosition.m_123343_() + 1.0);
        List list = world.m_6443_(ItemEntity.class, aabb, EntitySelector.f_20402_);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (ItemEntity entity : list) {
            ItemStack remainder;
            ItemStack leaveStack;
            ItemStack storeStack;
            ItemStack stack = entity.m_32055_().m_41777_();
            if (stack.m_41613_() > this.quantity) {
                storeStack = stack.m_41620_(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = ItemStack.f_41583_;
            }
            if ((remainder = InventoryUtil.storeItems(storeStack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot())) == storeStack) continue;
            if (remainder.m_41619_() && leaveStack.m_41619_()) {
                entity.m_146870_();
            } else if (remainder.m_41619_()) {
                entity.m_32045_(leaveStack);
            } else if (leaveStack.m_41619_()) {
                entity.m_32045_(remainder);
            } else {
                leaveStack.m_41769_(remainder.m_41613_());
                entity.m_32045_(leaveStack);
            }
            world.m_6798_(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

