/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record SpeakerPosition(@Nullable Level level, @Nonnull Vec3 position, @Nullable Entity entity) {
    public static SpeakerPosition of(@Nullable Level level, @Nonnull Vec3 position) {
        return new SpeakerPosition(level, position, null);
    }

    public static SpeakerPosition of(@Nonnull Entity entity) {
        return new SpeakerPosition(entity.f_19853_, entity.m_20299_(1.0f), entity);
    }

    public boolean withinDistance(SpeakerPosition other, double distanceSq) {
        return this.level == other.level && this.entity == other.entity && this.position.m_82557_(other.position) <= distanceSq;
    }

    public Message asMessage() {
        if (this.level == null) {
            throw new NullPointerException("Cannot send a position without a level");
        }
        return new Message(this.level.m_46472_().m_135782_(), this.position, this.entity == null ? OptionalInt.empty() : OptionalInt.of(this.entity.m_19879_()));
    }

    public static final class Message {
        private final ResourceLocation level;
        private final Vec3 position;
        private final OptionalInt entity;

        private Message(ResourceLocation level, Vec3 position, OptionalInt entity) {
            this.level = level;
            this.position = position;
            this.entity = entity;
        }

        public static Message read(@Nonnull FriendlyByteBuf buffer) {
            ResourceLocation level = buffer.m_130281_();
            Vec3 position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            OptionalInt entity = buffer.readBoolean() ? OptionalInt.of(buffer.readInt()) : OptionalInt.empty();
            return new Message(level, position, entity);
        }

        public void write(@Nonnull FriendlyByteBuf buffer) {
            buffer.m_130085_(this.level);
            buffer.writeDouble(this.position.f_82479_);
            buffer.writeDouble(this.position.f_82480_);
            buffer.writeDouble(this.position.f_82481_);
            buffer.writeBoolean(this.entity.isPresent());
            if (this.entity.isPresent()) {
                buffer.writeInt(this.entity.getAsInt());
            }
        }

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public SpeakerPosition reify() {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            if (level != null && !level.m_46472_().m_135782_().equals((Object)this.level)) {
                level = null;
            }
            return new SpeakerPosition((Level)level, this.position, level != null && this.entity.isPresent() ? level.m_6815_(this.entity.getAsInt()) : null);
        }
    }
}

