/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.Lua;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaNumber;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.compiler.BinOpr;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.compiler.ExpKind;
import cc.tweaked.internal.cobalt.compiler.FuncState;
import cc.tweaked.internal.cobalt.compiler.IntPtr;
import cc.tweaked.internal.cobalt.compiler.Lex;
import cc.tweaked.internal.cobalt.compiler.LuaC;
import cc.tweaked.internal.cobalt.compiler.UnOpr;
import cc.tweaked.internal.cobalt.function.LocalVariable;
import java.io.InputStream;

class Parser {
    private static final int LUAI_MAXCCALLS = 200;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    final Lex lexer;
    FuncState fs;
    private final LuaString source;
    public int nCcalls;

    private static String LUA_QL(String s) {
        return "'" + s + "'";
    }

    public Parser(InputStream stream, int firstByte, LuaString source) {
        this.lexer = new Lex(source, stream, firstByte);
        this.fs = null;
        this.source = source;
        this.lexer.skipShebang();
    }

    CompileException syntaxError(String msg) {
        return this.lexer.syntaxError(msg);
    }

    private void errorExpected(int token) throws CompileException {
        throw this.syntaxError(Lex.token2str(token) + " expected");
    }

    private void errorLimit(FuncState fs, int limit, String what) throws CompileException {
        String msg = fs.lineDefined == 0 ? "main function has more than " + limit + " " + what : "function at line " + fs.lineDefined + " has more than " + limit + " " + what;
        throw this.lexer.lexError(msg, 0);
    }

    private void checkLimit(FuncState fs, int value, int limit, String msg) throws CompileException {
        if (value > limit) {
            this.errorLimit(fs, limit, msg);
        }
    }

    private boolean testNext(int c) throws CompileException {
        if (this.lexer.token.token() == c) {
            this.lexer.nextToken();
            return true;
        }
        return false;
    }

    void check(int c) throws CompileException {
        if (this.lexer.token.token() != c) {
            this.errorExpected(c);
        }
    }

    private void checkNext(int c) throws CompileException {
        this.check(c);
        this.lexer.nextToken();
    }

    private void checkCondition(boolean c, String msg) throws CompileException {
        if (!c) {
            throw this.syntaxError(msg);
        }
    }

    private void checkMatch(int what, int who, int where) throws CompileException {
        if (this.testNext(what)) {
            return;
        }
        if (where != this.lexer.token.line()) {
            throw this.syntaxError(Lex.token2str(what) + " expected (to close " + Lex.token2str(who) + " at line " + where + ")");
        }
        this.errorExpected(what);
    }

    private LuaString strCheckName() throws CompileException {
        this.check(286);
        LuaString ts = this.lexer.token.stringContents();
        this.lexer.nextToken();
        return ts;
    }

    private void codeString(ExpDesc e, LuaString s) {
        e.init(ExpKind.VK, this.fs.stringK(s));
    }

    private void checkName(ExpDesc e) throws CompileException {
        this.codeString(e, this.strCheckName());
    }

    private int registerLocal(LuaString name) {
        FuncState fs = this.fs;
        int index = fs.locals.size();
        fs.locals.add(new LocalVariable(name, 0, 0));
        return index;
    }

    private void newLocal(String name, int n) throws CompileException {
        this.newLocal(this.lexer.newString(name), n);
    }

    private void newLocal(LuaString name, int n) throws CompileException {
        FuncState fs = this.fs;
        this.checkLimit(fs, fs.activeVariableCount + n + 1, 200, "local variables");
        fs.activeVariables[fs.activeVariableCount + n] = (short)this.registerLocal(name);
    }

    private void adjustLocalVars(int nVars) {
        FuncState fs = this.fs;
        fs.activeVariableCount = (short)(fs.activeVariableCount + nVars);
        while (nVars > 0) {
            fs.getLocal((int)(fs.activeVariableCount - nVars)).startpc = fs.pc;
            --nVars;
        }
    }

    void removeVars(int toLevel) {
        FuncState fs = this.fs;
        while (fs.activeVariableCount > toLevel) {
            fs.activeVariableCount = (short)(fs.activeVariableCount - 1);
            fs.getLocal((int)((short)(fs.activeVariableCount - 1))).endpc = fs.pc;
        }
    }

    private int indexUpvalue(FuncState fs, LuaString name, ExpDesc v) throws CompileException {
        for (int i = 0; i < fs.upvalues.size(); ++i) {
            FuncState.UpvalueDesc upvalue = fs.upvalues.get(i);
            if (upvalue.kind != v.kind || upvalue.info != v.info) continue;
            assert (upvalue.name == name);
            return i;
        }
        this.checkLimit(fs, fs.upvalues.size(), 60, "upvalues");
        assert (v.kind == ExpKind.VLOCAL || v.kind == ExpKind.VUPVAL);
        int index = fs.upvalues.size();
        fs.upvalues.add(new FuncState.UpvalueDesc(name, v.kind, (short)v.info));
        return index;
    }

    private int searchVar(FuncState fs, LuaString n) {
        for (int i = fs.activeVariableCount - 1; i >= 0; --i) {
            if (n != fs.getLocal((int)i).name) continue;
            return i;
        }
        return -1;
    }

    private void markUpvalue(FuncState fs, int level) {
        FuncState.BlockCnt block = fs.block;
        while (block != null && block.nactvar > level) {
            block = block.previous;
        }
        if (block != null) {
            block.upval = true;
        }
    }

    private ExpKind singleVarAux(FuncState fs, LuaString n, ExpDesc var, boolean base) throws CompileException {
        if (fs == null) {
            var.init(ExpKind.VGLOBAL, 255);
            return ExpKind.VGLOBAL;
        }
        int v = this.searchVar(fs, n);
        if (v >= 0) {
            var.init(ExpKind.VLOCAL, v);
            if (!base) {
                this.markUpvalue(fs, v);
            }
            return ExpKind.VLOCAL;
        }
        if (this.singleVarAux(fs.prev, n, var, false) == ExpKind.VGLOBAL) {
            return ExpKind.VGLOBAL;
        }
        var.info = this.indexUpvalue(fs, n, var);
        var.kind = ExpKind.VUPVAL;
        return ExpKind.VUPVAL;
    }

    private void singleVar(ExpDesc var) throws CompileException {
        var.position = this.lexer.token.position();
        FuncState fs = this.fs;
        LuaString varname = this.strCheckName();
        if (this.singleVarAux(fs, varname, var, true) == ExpKind.VGLOBAL) {
            var.info = fs.stringK(varname);
        }
    }

    private void adjustAssign(int nvars, int nexps, ExpDesc e) throws CompileException {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (e.kind.hasMultiRet()) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setReturns(e, extra);
            if (extra > 1) {
                fs.reserveRegs(extra - 1);
            }
        } else {
            if (e.kind != ExpKind.VVOID) {
                fs.exp2NextReg(e);
            }
            if (extra > 0) {
                int reg = fs.freeReg;
                fs.reserveRegs(extra);
                fs.nil(reg, extra);
            }
        }
    }

    private void enterLevel() throws CompileException {
        if (++this.nCcalls > 200) {
            throw this.lexer.lexError("chunk has too many syntax levels", 0);
        }
    }

    private void leaveLevel() {
        --this.nCcalls;
    }

    private void enterBlock(FuncState fs, FuncState.BlockCnt bl, boolean isbreakable) throws CompileException {
        bl.breaklist.value = -1;
        bl.isbreakable = isbreakable;
        bl.nactvar = fs.activeVariableCount;
        bl.upval = false;
        bl.previous = fs.block;
        fs.block = bl;
        assert (fs.freeReg == fs.activeVariableCount);
    }

    private void leaveBlock(FuncState fs) throws CompileException {
        FuncState.BlockCnt bl = fs.block;
        fs.block = bl.previous;
        this.removeVars(bl.nactvar);
        if (bl.upval) {
            fs.codeABC(35, bl.nactvar, 0, 0);
        }
        assert (!bl.isbreakable || !bl.upval);
        assert (bl.nactvar == fs.activeVariableCount);
        fs.freeReg = fs.activeVariableCount;
        fs.patchToHere(bl.breaklist.value);
    }

    private void pushClosure(FuncState child, Prototype childPrototype, ExpDesc v) throws CompileException {
        FuncState current = this.fs;
        int index = current.children.size();
        current.children.add(childPrototype);
        v.init(ExpKind.VRELOCABLE, current.codeABx(36, 0, index));
        for (FuncState.UpvalueDesc upvalue : child.upvalues) {
            int op = upvalue.kind == ExpKind.VLOCAL ? 0 : 4;
            current.codeABC(op, 0, upvalue.info, 0);
        }
    }

    FuncState openFunc() {
        FuncState fs;
        this.fs = fs = new FuncState(this.lexer, this.fs);
        return fs;
    }

    Prototype closeFunc() throws CompileException {
        FuncState fs = this.fs;
        this.removeVars(0);
        fs.ret(0, 0);
        assert (fs.block == null);
        this.fs = fs.prev;
        return fs.toPrototype();
    }

    private void field(ExpDesc v) throws CompileException {
        ExpDesc key = new ExpDesc();
        this.fs.exp2AnyReg(v);
        long indexPos = this.lexer.token.position();
        this.lexer.nextToken();
        this.checkName(key);
        this.fs.indexed(v, key, indexPos);
    }

    private void yindex(ExpDesc v) throws CompileException {
        this.lexer.nextToken();
        this.expression(v);
        this.fs.exp2Val(v);
        this.checkNext(93);
    }

    private void recordField(ConsControl cc) throws CompileException {
        FuncState fs = this.fs;
        int reg = this.fs.freeReg;
        ExpDesc key = new ExpDesc();
        ExpDesc val = new ExpDesc();
        if (this.lexer.token.token() == 286) {
            this.checkLimit(fs, cc.hashSize, 0x7FFFFFFD, "items in a constructor");
            this.checkName(key);
        } else {
            this.yindex(key);
        }
        ++cc.hashSize;
        this.checkNext(61);
        int rkkey = fs.exp2RK(key);
        this.expression(val);
        fs.codeABC(9, cc.table.info, rkkey, fs.exp2RK(val));
        fs.freeReg = reg;
    }

    void closeListField(FuncState fs, ConsControl cc) throws CompileException {
        if (cc.v.kind == ExpKind.VVOID) {
            return;
        }
        fs.exp2NextReg(cc.v);
        cc.v.kind = ExpKind.VVOID;
        if (cc.toStore == 50) {
            fs.setList(cc.table.info, cc.arraySize, cc.toStore);
            cc.toStore = 0;
        }
    }

    void lastListField(FuncState fs, ConsControl cc) throws CompileException {
        if (cc.toStore == 0) {
            return;
        }
        if (cc.v.kind.hasMultiRet()) {
            fs.setMultiRet(cc.v);
            fs.setList(cc.table.info, cc.arraySize, -1);
            --cc.arraySize;
        } else {
            if (cc.v.kind != ExpKind.VVOID) {
                fs.exp2NextReg(cc.v);
            }
            fs.setList(cc.table.info, cc.arraySize, cc.toStore);
        }
    }

    private void listField(ConsControl cc) throws CompileException {
        this.expression(cc.v);
        this.checkLimit(this.fs, cc.arraySize, 0x7FFFFFFD, "items in a constructor");
        ++cc.arraySize;
        ++cc.toStore;
    }

    private void constructor(ExpDesc t) throws CompileException {
        FuncState fs = this.fs;
        int line = this.lexer.token.line();
        int pc = fs.codeABC(10, 0, 0, 0);
        ConsControl cc = new ConsControl(t);
        t.init(ExpKind.VRELOCABLE, pc);
        cc.v.init(ExpKind.VVOID, 0);
        fs.exp2NextReg(t);
        this.checkNext(123);
        do {
            assert (cc.v.kind == ExpKind.VVOID || cc.toStore > 0);
            if (this.lexer.token.token() == 125) break;
            this.closeListField(fs, cc);
            switch (this.lexer.token.token()) {
                case 286: {
                    this.lexer.lookahead();
                    if (this.lexer.lookahead.token() != 61) {
                        this.listField(cc);
                        break;
                    }
                    this.recordField(cc);
                    break;
                }
                case 91: {
                    this.recordField(cc);
                    break;
                }
                default: {
                    this.listField(cc);
                }
            }
        } while (this.testNext(44) || this.testNext(59));
        this.checkMatch(125, 123, line);
        this.lastListField(fs, cc);
        int insn = fs.code[pc];
        insn = LuaC.SETARG_B(insn, Parser.luaO_int2fb(cc.arraySize));
        fs.code[pc] = insn = LuaC.SETARG_C(insn, Parser.luaO_int2fb(cc.hashSize));
    }

    private static int luaO_int2fb(int x) {
        int e = 0;
        while (x >= 16) {
            x = x + 1 >> 1;
            ++e;
        }
        if (x < 8) {
            return x;
        }
        return e + 1 << 3 | x - 8;
    }

    private void parlist() throws CompileException {
        FuncState fs = this.fs;
        int numParams = 0;
        fs.varargFlags = 0;
        if (this.lexer.token.token() != 41) {
            do {
                switch (this.lexer.token.token()) {
                    case 286: {
                        this.newLocal(this.strCheckName(), numParams++);
                        break;
                    }
                    case 279: {
                        this.lexer.nextToken();
                        this.newLocal("arg", numParams++);
                        fs.varargFlags = 5;
                        fs.varargFlags |= 2;
                        break;
                    }
                    default: {
                        throw this.syntaxError("<name> or " + Parser.LUA_QL("...") + " expected");
                    }
                }
            } while (fs.varargFlags == 0 && this.testNext(44));
        }
        this.adjustLocalVars(numParams);
        fs.numParams = fs.activeVariableCount - (fs.varargFlags & 1);
        fs.reserveRegs(fs.activeVariableCount);
    }

    private void body(ExpDesc e, boolean needSelf, int line) throws CompileException {
        FuncState newFuncState = this.openFunc();
        newFuncState.lineDefined = line;
        this.checkNext(40);
        if (needSelf) {
            this.newLocal("self", 0);
            this.adjustLocalVars(1);
        }
        this.parlist();
        this.checkNext(41);
        this.chunk();
        newFuncState.lastLineDefined = this.lexer.token.line();
        this.checkMatch(262, 265, line);
        Prototype proto = this.closeFunc();
        this.pushClosure(newFuncState, proto, e);
    }

    private int expList1(ExpDesc v) throws CompileException {
        int n = 1;
        this.expression(v);
        while (this.testNext(44)) {
            this.fs.exp2NextReg(v);
            this.expression(v);
            ++n;
        }
        return n;
    }

    private void funcArgs(ExpDesc f) throws CompileException {
        int nArgs;
        FuncState fs = this.fs;
        ExpDesc args = new ExpDesc();
        long position = this.lexer.token.position();
        int line = this.lexer.token.line();
        switch (this.lexer.token.token()) {
            case 40: {
                if (line != this.lexer.lastLine()) {
                    throw this.syntaxError("ambiguous syntax (function call x new statement)");
                }
                this.lexer.nextToken();
                if (this.lexer.token.token() == 41) {
                    args.kind = ExpKind.VVOID;
                } else {
                    this.expList1(args);
                    fs.setMultiRet(args);
                }
                this.checkMatch(41, 40, line);
                break;
            }
            case 123: {
                this.constructor(args);
                break;
            }
            case 287: {
                this.codeString(args, this.lexer.token.stringContents());
                this.lexer.nextToken();
                break;
            }
            default: {
                throw this.syntaxError("function arguments expected");
            }
        }
        assert (f.kind == ExpKind.VNONRELOC);
        int base = f.info;
        if (args.kind.hasMultiRet()) {
            nArgs = -1;
        } else {
            if (args.kind != ExpKind.VVOID) {
                fs.exp2NextReg(args);
            }
            nArgs = fs.freeReg - (base + 1);
        }
        f.init(ExpKind.VCALL, fs.codeABCAt(28, base, nArgs + 1, 2, position));
        fs.freeReg = base + 1;
    }

    private void prefixExpression(ExpDesc v) throws CompileException {
        switch (this.lexer.token.token()) {
            case 40: {
                int line = this.lexer.token.line();
                this.lexer.nextToken();
                this.expression(v);
                this.checkMatch(41, 40, line);
                this.fs.dischargeVars(v);
                return;
            }
            case 286: {
                this.singleVar(v);
                return;
            }
        }
        throw this.syntaxError("unexpected symbol");
    }

    private void primaryExpression(ExpDesc v) throws CompileException {
        FuncState fs = this.fs;
        this.prefixExpression(v);
        block6: while (true) {
            switch (this.lexer.token.token()) {
                case 46: {
                    this.field(v);
                    continue block6;
                }
                case 91: {
                    ExpDesc key = new ExpDesc();
                    fs.exp2AnyReg(v);
                    long indexPos = this.lexer.token.position();
                    this.yindex(key);
                    fs.indexed(v, key, indexPos);
                    continue block6;
                }
                case 58: {
                    ExpDesc key = new ExpDesc();
                    this.lexer.nextToken();
                    this.checkName(key);
                    fs.self(v, key);
                    this.funcArgs(v);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 287: {
                    fs.exp2NextReg(v);
                    this.funcArgs(v);
                    continue block6;
                }
            }
            break;
        }
    }

    private void simpleExpression(ExpDesc v) throws CompileException {
        switch (this.lexer.token.token()) {
            case 285: {
                v.init(ExpKind.VKNUM, 0);
                v.setNval(this.lexer.token.numberContents());
                break;
            }
            case 287: {
                this.codeString(v, this.lexer.token.stringContents());
                break;
            }
            case 269: {
                v.init(ExpKind.VNIL, 0);
                break;
            }
            case 275: {
                v.init(ExpKind.VTRUE, 0);
                break;
            }
            case 263: {
                v.init(ExpKind.VFALSE, 0);
                break;
            }
            case 279: {
                FuncState fs = this.fs;
                this.checkCondition(fs.varargFlags != 0, "cannot use " + Parser.LUA_QL("...") + " outside a vararg function");
                fs.varargFlags &= 0xFFFFFFFB;
                v.init(ExpKind.VVARARG, fs.codeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(v);
                return;
            }
            case 265: {
                this.lexer.nextToken();
                this.body(v, false, this.lexer.token.line());
                return;
            }
            default: {
                this.primaryExpression(v);
                return;
            }
        }
        this.lexer.nextToken();
    }

    private BinOpr subExpression(ExpDesc v, int limit) throws CompileException {
        this.enterLevel();
        UnOpr unop = UnOpr.ofToken(this.lexer.token.token());
        if (unop != null) {
            long opPosition = this.lexer.token.position();
            this.lexer.nextToken();
            this.subExpression(v, 8);
            this.fs.prefix(unop, v, opPosition);
        } else {
            this.simpleExpression(v);
        }
        BinOpr binop = BinOpr.ofToken(this.lexer.token.token());
        while (binop != null && binop.left > limit) {
            long position = this.lexer.token.position();
            this.lexer.nextToken();
            this.fs.infix(binop, v);
            ExpDesc v2 = new ExpDesc();
            BinOpr nextop = this.subExpression(v2, binop.right);
            this.fs.posfix(binop, v, v2, position);
            binop = nextop;
        }
        this.leaveLevel();
        return binop;
    }

    private void expression(ExpDesc v) throws CompileException {
        this.subExpression(v, 0);
    }

    private static boolean blockFollow(int token) {
        switch (token) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 284: {
                return true;
            }
        }
        return false;
    }

    private void block() throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.enterBlock(fs, bl, false);
        this.chunk();
        LuaC._assert(bl.breaklist.value == -1);
        this.leaveBlock(fs);
    }

    private void checkConflict(LhsAssign lh, ExpDesc v) throws CompileException {
        FuncState fs = this.fs;
        int extra = fs.freeReg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.kind == ExpKind.VINDEXED) {
                if (lh.v.info == v.info) {
                    conflict = true;
                    lh.v.info = extra;
                }
                if (lh.v.aux == v.info) {
                    conflict = true;
                    lh.v.aux = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            fs.codeABC(0, fs.freeReg, v.info, 0);
            fs.reserveRegs(1);
        }
    }

    private void assignment(LhsAssign lh, int nvars) throws CompileException {
        ExpDesc e = new ExpDesc();
        this.checkCondition(lh.v.kind.isVar(), "syntax error");
        if (this.testNext(44)) {
            LhsAssign nv = new LhsAssign(lh);
            this.primaryExpression(nv.v);
            if (nv.v.kind == ExpKind.VLOCAL) {
                this.checkConflict(lh, nv.v);
            }
            this.assignment(nv, nvars + 1);
        } else {
            this.checkNext(61);
            int nexps = this.expList1(e);
            if (nexps != nvars) {
                this.adjustAssign(nvars, nexps, e);
                if (nexps > nvars) {
                    this.fs.freeReg -= nexps - nvars;
                }
            } else {
                this.fs.setOneRet(e);
                this.fs.storeVar(lh.v, e);
                return;
            }
        }
        e.init(ExpKind.VNONRELOC, this.fs.freeReg - 1);
        this.fs.storeVar(lh.v, e);
    }

    private int cond() throws CompileException {
        ExpDesc v = new ExpDesc();
        this.expression(v);
        if (v.kind == ExpKind.VNIL) {
            v.kind = ExpKind.VFALSE;
        }
        this.fs.goIfTrue(v);
        return v.f.value;
    }

    private void breakStmt() throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = fs.block;
        boolean upval = false;
        while (bl != null && !bl.isbreakable) {
            upval |= bl.upval;
            bl = bl.previous;
        }
        if (bl == null) {
            throw this.syntaxError("no loop to break");
        }
        if (upval) {
            fs.codeABC(35, bl.nactvar, 0, 0);
        }
        fs.concat(bl.breaklist, fs.jump());
    }

    private void whileStmt() throws CompileException {
        int line = this.lexer.token.line();
        this.lexer.nextToken();
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        int whileInit = fs.getLabel();
        int contExit = this.cond();
        this.enterBlock(fs, bl, true);
        this.checkNext(259);
        this.block();
        fs.patchList(fs.jump(), whileInit);
        this.checkMatch(262, 277, line);
        this.leaveBlock(fs);
        fs.patchToHere(contExit);
    }

    private void repeatStmt() throws CompileException {
        int line = this.lexer.token.line();
        this.lexer.nextToken();
        FuncState fs = this.fs;
        int repeatInit = fs.getLabel();
        FuncState.BlockCnt bl1 = new FuncState.BlockCnt();
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        this.enterBlock(fs, bl1, true);
        this.enterBlock(fs, bl2, false);
        this.chunk();
        this.checkMatch(276, 272, line);
        int condexit = this.cond();
        if (!bl2.upval) {
            this.leaveBlock(fs);
            fs.patchList(condexit, repeatInit);
        } else {
            this.breakStmt();
            fs.patchToHere(condexit);
            this.leaveBlock(fs);
            fs.patchList(fs.jump(), repeatInit);
        }
        this.leaveBlock(fs);
    }

    private void exp1() throws CompileException {
        ExpDesc e = new ExpDesc();
        this.expression(e);
        this.fs.exp2NextReg(e);
    }

    private void forBody(int base, long position, int nvars, boolean isNum) throws CompileException {
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustLocalVars(3);
        this.checkNext(259);
        int prep = isNum ? fs.codeAsBx(32, base, -1) : fs.jump();
        this.enterBlock(fs, bl, false);
        this.adjustLocalVars(nvars);
        fs.reserveRegs(nvars);
        this.block();
        this.leaveBlock(fs);
        fs.patchToHere(prep);
        int endFor = isNum ? fs.codeAsBxAt(31, base, -1, position) : fs.codeABCAt(33, base, 0, nvars, position);
        fs.patchList(isNum ? endFor : fs.jump(), prep + 1);
    }

    private void forNum(LuaString varName, long position) throws CompileException {
        FuncState fs = this.fs;
        int base = fs.freeReg;
        this.newLocal("(for index)", 0);
        this.newLocal("(for limit)", 1);
        this.newLocal("(for step)", 2);
        this.newLocal(varName, 3);
        this.checkNext(61);
        this.exp1();
        this.checkNext(44);
        this.exp1();
        if (this.testNext(44)) {
            this.exp1();
        } else {
            fs.codeABx(1, fs.freeReg, fs.numberK(LuaInteger.valueOf(1)));
            fs.reserveRegs(1);
        }
        this.forBody(base, position, 1, true);
    }

    private void forList(LuaString indexName) throws CompileException {
        FuncState fs = this.fs;
        ExpDesc e = new ExpDesc();
        int nvars = 0;
        int base = fs.freeReg;
        this.newLocal("(for generator)", nvars++);
        this.newLocal("(for state)", nvars++);
        this.newLocal("(for control)", nvars++);
        this.newLocal(indexName, nvars++);
        while (this.testNext(44)) {
            this.newLocal(this.strCheckName(), nvars++);
        }
        this.checkNext(267);
        long position = this.lexer.token.position();
        this.adjustAssign(3, this.expList1(e), e);
        fs.checkStack(3);
        this.forBody(base, position, nvars - 3, false);
    }

    private void forStmt() throws CompileException {
        long position = this.lexer.token.position();
        this.lexer.nextToken();
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.enterBlock(fs, bl, true);
        LuaString varName = this.strCheckName();
        switch (this.lexer.token.token()) {
            case 61: {
                this.forNum(varName, position);
                break;
            }
            case 44: 
            case 267: {
                this.forList(varName);
                break;
            }
            default: {
                throw this.syntaxError(Parser.LUA_QL("=") + " or " + Parser.LUA_QL("in") + " expected");
            }
        }
        this.checkMatch(262, 264, Lex.unpackLine(position));
        this.leaveBlock(fs);
    }

    private int testThenBlock() throws CompileException {
        this.lexer.nextToken();
        int condExit = this.cond();
        this.checkNext(274);
        this.block();
        return condExit;
    }

    private void ifStat() throws CompileException {
        int line = this.lexer.token.line();
        FuncState fs = this.fs;
        IntPtr escapeList = new IntPtr(-1);
        int flist = this.testThenBlock();
        while (this.lexer.token.token() == 261) {
            fs.concat(escapeList, fs.jump());
            fs.patchToHere(flist);
            flist = this.testThenBlock();
        }
        if (this.lexer.token.token() == 260) {
            fs.concat(escapeList, fs.jump());
            fs.patchToHere(flist);
            this.lexer.nextToken();
            this.block();
        } else {
            fs.concat(escapeList, flist);
        }
        fs.patchToHere(escapeList.value);
        this.checkMatch(262, 266, line);
    }

    private void localFunc() throws CompileException {
        ExpDesc v = new ExpDesc();
        FuncState fs = this.fs;
        this.newLocal(this.strCheckName(), 0);
        v.init(ExpKind.VLOCAL, fs.freeReg);
        fs.reserveRegs(1);
        this.adjustLocalVars(1);
        ExpDesc b = new ExpDesc();
        this.body(b, false, this.lexer.token.line());
        fs.storeVar(v, b);
        fs.getLocal((int)(fs.activeVariableCount - 1)).startpc = fs.pc;
    }

    private void localStmt() throws CompileException {
        int nexps;
        int nvars = 0;
        ExpDesc e = new ExpDesc();
        do {
            this.newLocal(this.strCheckName(), nvars++);
        } while (this.testNext(44));
        if (this.testNext(61)) {
            nexps = this.expList1(e);
        } else {
            e.kind = ExpKind.VVOID;
            nexps = 0;
        }
        this.adjustAssign(nvars, nexps, e);
        this.adjustLocalVars(nvars);
    }

    private boolean funcName(ExpDesc v) throws CompileException {
        this.singleVar(v);
        while (this.lexer.token.token() == 46) {
            this.field(v);
        }
        boolean needSelf = false;
        if (this.lexer.token.token() == 58) {
            needSelf = true;
            this.field(v);
        }
        return needSelf;
    }

    private void funcStmt() throws CompileException {
        long position = this.lexer.token.position();
        this.lexer.nextToken();
        ExpDesc v = new ExpDesc();
        ExpDesc b = new ExpDesc();
        boolean needSelf = this.funcName(v);
        this.body(b, needSelf, Lex.unpackLine(position));
        this.fs.storeVar(v, b);
        this.fs.fixPosition(position);
    }

    private void exprStmt() throws CompileException {
        FuncState fs = this.fs;
        LhsAssign v = new LhsAssign(null);
        this.primaryExpression(v.v);
        if (v.v.kind == ExpKind.VCALL) {
            fs.code[v.v.info] = LuaC.SETARG_C(fs.code[v.v.info], 1);
        } else {
            this.assignment(v, 1);
        }
    }

    private void returnStmt() throws CompileException {
        int first;
        int nret;
        FuncState fs = this.fs;
        this.lexer.nextToken();
        if (Parser.blockFollow(this.lexer.token.token()) || this.lexer.token.token() == 59) {
            nret = 0;
            first = 0;
        } else {
            ExpDesc e = new ExpDesc();
            nret = this.expList1(e);
            if (e.kind.hasMultiRet()) {
                fs.setMultiRet(e);
                if (e.kind == ExpKind.VCALL && nret == 1) {
                    fs.code[e.info] = LuaC.SET_OPCODE(fs.code[e.info], 29);
                    int op = fs.code[e.info];
                    LuaC._assert(Lua.GETARG_A(op) == fs.activeVariableCount);
                }
                first = fs.activeVariableCount;
                nret = -1;
            } else if (nret == 1) {
                first = fs.exp2AnyReg(e);
            } else {
                fs.exp2NextReg(e);
                first = fs.activeVariableCount;
                assert (nret == fs.freeReg - first);
            }
        }
        fs.ret(first, nret);
    }

    private boolean statement() throws CompileException {
        switch (this.lexer.token.token()) {
            case 266: {
                this.ifStat();
                return false;
            }
            case 277: {
                this.whileStmt();
                return false;
            }
            case 259: {
                int line = this.lexer.token.line();
                this.lexer.nextToken();
                this.block();
                this.checkMatch(262, 259, line);
                return false;
            }
            case 264: {
                this.forStmt();
                return false;
            }
            case 272: {
                this.repeatStmt();
                return false;
            }
            case 265: {
                this.funcStmt();
                return false;
            }
            case 268: {
                this.lexer.nextToken();
                if (this.testNext(265)) {
                    this.localFunc();
                } else {
                    this.localStmt();
                }
                return false;
            }
            case 273: {
                this.returnStmt();
                return true;
            }
            case 258: {
                this.lexer.nextToken();
                this.breakStmt();
                return true;
            }
        }
        this.exprStmt();
        return false;
    }

    void chunk() throws CompileException {
        boolean islast = false;
        this.enterLevel();
        while (!islast && !Parser.blockFollow(this.lexer.token.token())) {
            islast = this.statement();
            this.testNext(59);
            assert (this.fs.maxStackSize >= this.fs.freeReg && this.fs.freeReg >= this.fs.activeVariableCount);
            this.fs.freeReg = this.fs.activeVariableCount;
        }
        this.leaveLevel();
    }

    static class LhsAssign {
        final LhsAssign prev;
        final ExpDesc v = new ExpDesc();

        LhsAssign(LhsAssign prev) {
            this.prev = prev;
        }
    }

    static class ConsControl {
        final ExpDesc v = new ExpDesc();
        final ExpDesc table;
        int hashSize;
        int arraySize;
        int toStore;

        ConsControl(ExpDesc table) {
            this.table = table;
        }
    }

    static class ExpDesc {
        ExpKind kind;
        long position;
        private LuaNumber nval;
        int info;
        int aux;
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        ExpDesc() {
        }

        void init(ExpKind kind, int info) {
            this.kind = kind;
            this.info = info;
            this.f.value = -1;
            this.t.value = -1;
        }

        public void setNval(LuaNumber r) {
            this.nval = r;
        }

        public LuaNumber nval() {
            return this.nval == null ? LuaInteger.valueOf(this.info) : this.nval;
        }

        boolean hasjumps() {
            return this.t.value != this.f.value;
        }

        boolean isnumeral() {
            return this.kind == ExpKind.VKNUM && this.t.value == -1 && this.f.value == -1;
        }

        public void setValue(ExpDesc other) {
            this.kind = other.kind;
            this.nval = other.nval;
            this.info = other.info;
            this.aux = other.aux;
            this.t.value = other.t.value;
            this.f.value = other.f.value;
        }
    }
}

