/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaValue;

public abstract class Varargs {
    public abstract LuaValue arg(int var1);

    public abstract int count();

    public abstract LuaValue first();

    public abstract Varargs asImmutable();

    public abstract void fill(LuaValue[] var1, int var2);

    public int type(int i) {
        return this.arg(i).type();
    }

    public boolean isNil(int i) {
        return this.arg(i).isNil();
    }

    public boolean exists(int i) {
        return i > 0 && i <= this.count();
    }

    public LuaValue checkValue(int i) throws LuaError {
        if (i <= this.count()) {
            return this.arg(i);
        }
        throw ErrorFactory.argError(i, "value expected");
    }

    public LuaValue checkNotNil(int i) throws LuaError {
        return this.arg(i).checkNotNil();
    }

    public static void argCheck(boolean test, int i, String msg) throws LuaError {
        if (!test) {
            throw ErrorFactory.argError(i, msg);
        }
    }

    public boolean isNoneOrNil(int i) {
        return i > this.count() || this.arg(i).isNil();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int n = this.count();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(this.arg(i).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public Varargs subargs(int start) {
        int end = this.count();
        switch (end - start) {
            case 0: {
                return this.arg(start);
            }
            case 1: {
                return new LuaValue.PairVarargs(this.arg(start), this.arg(end));
            }
        }
        return end < start ? Constants.NONE : new SubVarargs(this, start, end);
    }

    private static class SubVarargs
    extends DepthVarargs {
        private final Varargs v;
        private final int start;
        private final int end;

        public SubVarargs(Varargs varargs, int start, int end) {
            super(SubVarargs.depth(varargs));
            this.v = varargs;
            this.start = start;
            this.end = end;
        }

        @Override
        public LuaValue arg(int i) {
            return (i += this.start - 1) >= this.start && i <= this.end ? this.v.arg(i) : Constants.NIL;
        }

        @Override
        public LuaValue first() {
            return this.v.arg(this.start);
        }

        @Override
        public Varargs asImmutable() {
            Varargs vClone = this.v.asImmutable();
            return vClone == this.v ? this : new SubVarargs(vClone, this.start, this.end);
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            int size = this.end + 1 - this.start;
            for (int i = 0; i < size; ++i) {
                array[offset + i] = this.v.arg(this.start + i);
            }
        }

        @Override
        public int count() {
            return this.end + 1 - this.start;
        }
    }

    protected static abstract class DepthVarargs
    extends Varargs {
        protected final int depth;

        protected DepthVarargs(int depth) {
            this.depth = depth;
        }

        public static int depth(Varargs varargs) {
            return varargs instanceof DepthVarargs ? ((DepthVarargs)varargs).depth : 1;
        }
    }
}

