/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.access.Cullable;
import dev.tr7zw.entityculling.access.EntityRendererInter;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Shadow
    private EntityRenderDispatcher f_109463_;

    @Inject(at={@At(value="HEAD")}, method={"renderEntity"}, cancellable=true)
    private void renderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo info) {
        if (EntityCullingModBase.instance.config.skipEntityCulling) {
            return;
        }
        Cullable cullable = (Cullable)entity;
        if (!cullable.isForcedVisible() && cullable.isCulled() && !entity.f_19811_) {
            EntityRenderer entityRenderer = this.f_109463_.m_114382_(entity);
            EntityRendererInter entityRendererInter = (EntityRendererInter)entityRenderer;
            if (EntityCullingModBase.instance.config.renderNametagsThroughWalls && matrices != null && vertexConsumers != null && entityRendererInter.shadowShouldShowName(entity)) {
                double x = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_()) - cameraX;
                double y = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_()) - cameraY;
                double z = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_()) - cameraZ;
                Vec3 vec3d = entityRenderer.m_7860_(entity, tickDelta);
                double d = x + vec3d.f_82479_;
                double e = y + vec3d.f_82480_;
                double f = z + vec3d.f_82481_;
                matrices.m_85836_();
                matrices.m_85837_(d, e, f);
                entityRendererInter.shadowRenderNameTag(entity, entity.m_5446_(), matrices, vertexConsumers, this.f_109463_.m_114394_(entity, tickDelta));
                matrices.m_85849_();
            }
            ++EntityCullingModBase.instance.skippedEntities;
            info.cancel();
            return;
        }
        ++EntityCullingModBase.instance.renderedEntities;
        cullable.setOutOfCamera(false);
    }
}

