/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.handler.advancement.mod.MonsterHunterModifier;
import vazkii.quark.base.handler.advancement.mod.TwoByTwoModifier;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.FoxhoundRenderer;
import vazkii.quark.content.mobs.entity.Foxhound;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class FoxhoundModule
extends QuarkModule {
    public static EntityType<Foxhound> foxhoundType;
    @Config(description="The chance coal will tame a foxhound")
    public static double tameChance;
    @Config(flag="foxhound_furnace")
    public static boolean foxhoundsSpeedUpFurnaces;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config
    public static EntitySpawnConfig lesserSpawnConfig;
    public static TagKey<Block> foxhoundSpawnableTag;
    public static QuarkGenericTrigger foxhoundFurnaceTrigger;

    @Override
    public void register() {
        foxhoundType = EntityType.Builder.m_20704_(Foxhound::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.8f).m_20702_(8).m_20719_().setCustomClientFactory((spawnEntity, world) -> new Foxhound((EntityType<? extends Foxhound>)foxhoundType, (Level)world)).m_20712_("foxhound");
        RegistryHelper.register(foxhoundType, (String)"foxhound", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(this, foxhoundType, MobCategory.MONSTER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Foxhound::spawnPredicate, spawnConfig);
        EntitySpawnHandler.track(this, foxhoundType, MobCategory.MONSTER, lesserSpawnConfig, true);
        EntitySpawnHandler.addEgg(foxhoundType, 8981773, 15904587, spawnConfig);
        EntityAttributeHandler.put(foxhoundType, Wolf::m_30425_);
        QuarkAdvancementHandler.addModifier(new MonsterHunterModifier(this, (Set<EntityType<?>>)ImmutableSet.of(foxhoundType)));
        QuarkAdvancementHandler.addModifier(new TwoByTwoModifier(this, (Set<EntityType<?>>)ImmutableSet.of(foxhoundType)));
        foxhoundFurnaceTrigger = QuarkAdvancementHandler.registerGenericTrigger("foxhound_furnace");
    }

    @Override
    public void setup() {
        foxhoundSpawnableTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "foxhound_spawnable"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(foxhoundType, FoxhoundRenderer::new);
    }

    @SubscribeEvent
    public void onAggro(LivingChangeTargetEvent event) {
        if (event.getNewTarget() != null && event.getTargetType() != LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET && event.getEntity().m_6095_() == EntityType.f_20460_ && event.getNewTarget().m_6095_() == foxhoundType && ((Foxhound)event.getNewTarget()).m_21824_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepCheck(SleepingLocationCheckEvent event) {
        if (event.getEntity() instanceof Foxhound) {
            boolean sleep;
            Level world = event.getEntity().f_19853_;
            BlockPos pos = event.getSleepingLocation();
            boolean bl = sleep = world.m_8055_(pos.m_7495_()).getLightEmission((BlockGetter)world, pos.m_7495_()) > 2;
            if (sleep) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    static {
        tameChance = 0.05;
        foxhoundsSpeedUpFurnaces = true;
        spawnConfig = new EntitySpawnConfig(30, 1, 2, CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:nether_wastes", "minecraft:basalt_deltas"));
        lesserSpawnConfig = new CostSensitiveEntitySpawnConfig(2, 1, 1, 0.7, 0.15, CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:soul_sand_valley"));
    }
}

