/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;
import vazkii.quark.base.module.config.type.BiomeTagConfig;
import vazkii.quark.base.module.config.type.IBiomeConfig;
import vazkii.quark.base.module.config.type.StrictBiomeConfig;

public class CompoundBiomeConfig
extends AbstractConfigType
implements IBiomeConfig {
    @Config(description="Biome tags for which this should spawn in. Must match both this and 'biomes' to spawn.")
    public BiomeTagConfig tags;
    @Config(description="Biome names this should spawn in. Must match both this and 'types' to spawn.")
    public StrictBiomeConfig biomes;

    private CompoundBiomeConfig(BiomeTagConfig tags, StrictBiomeConfig biomes) {
        this.tags = tags;
        this.biomes = biomes;
    }

    @SafeVarargs
    public static CompoundBiomeConfig fromBiomeTags(boolean isBlacklist, TagKey<Biome> ... typesIn) {
        return new CompoundBiomeConfig(new BiomeTagConfig(isBlacklist, typesIn), CompoundBiomeConfig.noSBC());
    }

    public static CompoundBiomeConfig fromBiomeTagStrings(boolean isBlacklist, String ... typesIn) {
        return new CompoundBiomeConfig(BiomeTagConfig.fromStrings(isBlacklist, typesIn), CompoundBiomeConfig.noSBC());
    }

    public static CompoundBiomeConfig fromBiomeReslocs(boolean isBlacklist, String ... typesIn) {
        return new CompoundBiomeConfig(CompoundBiomeConfig.noBTC(), new StrictBiomeConfig(isBlacklist, typesIn));
    }

    public static CompoundBiomeConfig all() {
        return new CompoundBiomeConfig(CompoundBiomeConfig.noBTC(), CompoundBiomeConfig.noSBC());
    }

    private static BiomeTagConfig noBTC() {
        return new BiomeTagConfig(true, new TagKey[0]);
    }

    private static StrictBiomeConfig noSBC() {
        return new StrictBiomeConfig(true, new String[0]);
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        this.tags.onReload(flagManager);
        this.biomes.onReload(flagManager);
    }

    @Override
    public boolean canSpawn(Holder<Biome> b) {
        return b != null && this.tags.canSpawn(b) && this.biomes.canSpawn(b);
    }
}

