/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public enum PBRType {
    NORMAL("_n", 0x7F7FFFFF),
    SPECULAR("_s", 0);

    private static final PBRType[] VALUES;
    private final String suffix;
    private final int defaultValue;

    private PBRType(String suffix, int defaultValue) {
        this.suffix = suffix;
        this.defaultValue = defaultValue;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public ResourceLocation appendToFileLocation(ResourceLocation location) {
        String path = location.m_135815_();
        int extensionIndex = FilenameUtils.indexOfExtension((String)path);
        String newPath = extensionIndex != -1 ? path.substring(0, extensionIndex) + this.suffix + path.substring(extensionIndex) : path + this.suffix;
        return new ResourceLocation(location.m_135827_(), newPath);
    }

    @Nullable
    public static PBRType fromFileLocation(String location) {
        for (PBRType type : VALUES) {
            if (!location.endsWith(type.getSuffix())) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = PBRType.values();
    }
}

