/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum;

import net.minecraft.world.phys.AABB;

public class BoxCuller {
    private final double maxDistance;
    private double minAllowedX;
    private double maxAllowedX;
    private double minAllowedY;
    private double maxAllowedY;
    private double minAllowedZ;
    private double maxAllowedZ;

    public BoxCuller(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public void setPosition(double cameraX, double cameraY, double cameraZ) {
        this.minAllowedX = cameraX - this.maxDistance;
        this.maxAllowedX = cameraX + this.maxDistance;
        this.minAllowedY = cameraY - this.maxDistance;
        this.maxAllowedY = cameraY + this.maxDistance;
        this.minAllowedZ = cameraZ - this.maxDistance;
        this.maxAllowedZ = cameraZ + this.maxDistance;
    }

    public boolean isCulled(AABB aabb) {
        return this.isCulled((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_);
    }

    public boolean isCulled(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if ((double)maxX < this.minAllowedX || (double)minX > this.maxAllowedX) {
            return true;
        }
        if ((double)maxY < this.minAllowedY || (double)minY > this.maxAllowedY) {
            return true;
        }
        return (double)maxZ < this.minAllowedZ || (double)minZ > this.maxAllowedZ;
    }
}

