/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.parameter;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class SodiumParameters
extends Parameters {
    public final ShaderAttributeInputs inputs;
    public final float positionScale;
    public final float positionOffset;
    public final float textureScale;
    public AlphaTest alpha;

    public SodiumParameters(Patch patch, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap, AlphaTest alpha, ShaderAttributeInputs inputs, float positionScale, float positionOffset, float textureScale) {
        super(patch, textureMap);
        this.inputs = inputs;
        this.positionScale = positionScale;
        this.positionOffset = positionOffset;
        this.textureScale = textureScale;
        this.alpha = alpha;
    }

    @Override
    public AlphaTest getAlphaTest() {
        return this.alpha;
    }

    @Override
    public TextureStage getTextureStage() {
        return TextureStage.GBUFFERS_AND_SHADOW;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + Float.floatToIntBits(this.positionScale);
        result = 31 * result + Float.floatToIntBits(this.positionOffset);
        result = 31 * result + Float.floatToIntBits(this.textureScale);
        result = 31 * result + (this.alpha == null ? 0 : this.alpha.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SodiumParameters other = (SodiumParameters)obj;
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionScale) != Float.floatToIntBits(other.positionScale)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionOffset) != Float.floatToIntBits(other.positionOffset)) {
            return false;
        }
        if (Float.floatToIntBits(this.textureScale) != Float.floatToIntBits(other.textureScale)) {
            return false;
        }
        return !(this.alpha == null ? other.alpha != null : !this.alpha.equals(other.alpha));
    }
}

