/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTooltip;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WHelp
extends WContainer {
    protected String key;

    public WHelp(String content) {
        this.key = content;
        if (((Boolean)Utilities.I18n.search((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.\u0001.title"}, (String)this.key)), (Object[])new Object[0]).two).booleanValue() && ((Boolean)Utilities.I18n.search((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.\u0001.help"}, (String)this.key)), (Object[])new Object[0]).two).booleanValue()) {
            this.add(new Impl());
        }
    }

    private class Impl
    extends WTooltip {
        public Impl() {
            super("common.help");
        }

        @Override
        public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
            super.onDraw(gui, xMouse, yMouse);
            gui.drawResourceContinuous(Resource.WGT_PANEL_N, 150, 162, 26, 26, 4);
            gui.drawResource(Resource.WGT_HELP_N, 152, 165);
            return false;
        }

        @Override
        public boolean mouseIn(int xMouse, int yMouse) {
            return JecaGui.mouseIn(150, 166, 26, 22, xMouse, yMouse);
        }

        @Override
        public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
            boolean ret = this.mouseIn(xMouse, yMouse);
            if (ret) {
                gui.root.setOverlay(new Doc());
            }
            return ret;
        }
    }

    private class Doc
    extends WContainer {
        Text text = new Text();
        WSwitcher switcher = new WSwitcher(7, 146, 162, this.text.amount()).setListener(i -> this.text.setPage(i.getIndex()));

        public Doc() {
            WText title = new WText(7, 7, JecaGui.FontType.SHADOW, Utilities.I18n.get("gui." + WHelp.this.key + ".title", new Object[0]));
            this.add(new WPanel(), new Icon(), title, this.text, this.switcher);
        }

        @Override
        public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
            if (!super.onMouseClicked(gui, xMouse, yMouse, button)) {
                gui.root.remove(this);
            }
            return true;
        }

        @Override
        public boolean onMouseScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
            this.switcher.move(-diff);
            this.text.setPage(this.switcher.getIndex());
            return super.onMouseScroll(gui, xMouse, yMouse, diff);
        }

        public class Text
        implements IWidget {
            List<List<String>> pages = new ArrayList<List<String>>();
            int page;

            public Text() {
                List<String> ss = Utilities.I18n.wrap(Utilities.I18n.get("gui." + WHelp.this.key + ".help", new Object[0]), 162);
                ArrayList<String> tmp = new ArrayList<String>();
                int count = 0;
                for (String s : ss) {
                    if (s.endsWith("\f")) {
                        tmp.add(s.substring(0, s.length() - 1));
                        this.pages.add(tmp);
                        tmp = new ArrayList();
                        count = 0;
                        continue;
                    }
                    if (count == 11) {
                        tmp.add(s);
                        this.pages.add(tmp);
                        tmp = new ArrayList();
                        count = 0;
                        continue;
                    }
                    tmp.add(s);
                    ++count;
                }
                if (!tmp.isEmpty()) {
                    this.pages.add(tmp);
                }
            }

            @Override
            public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
                gui.drawSplitText(7.0f, 21.0f, JecaGui.FontType.PLAIN, this.pages.get(this.page));
                return false;
            }

            public int amount() {
                return this.pages.size();
            }

            public void setPage(int i) {
                this.page = i;
            }
        }

        public class Icon
        extends WTooltip {
            public Icon() {
                super("common.close");
            }

            @Override
            public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
                super.onDraw(gui, xMouse, yMouse);
                gui.drawResourceContinuous(Resource.WGT_HELP_B, 150, 162, 26, 26, 4);
                gui.drawResource(Resource.WGT_HELP_F, 152, 165);
                return false;
            }

            @Override
            public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
                super.onTooltip(gui, xMouse, yMouse, tooltip);
                return this.mouseIn(xMouse, yMouse);
            }

            @Override
            public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
                boolean ret = this.mouseIn(xMouse, yMouse);
                if (ret) {
                    gui.root.setOverlay(null);
                }
                return ret;
            }

            @Override
            public boolean mouseIn(int xMouse, int yMouse) {
                return JecaGui.mouseIn(150, 166, 26, 22, xMouse, yMouse);
            }

            @Override
            public boolean onKeyPressed(JecaGui gui, int key, int modifier) {
                if (super.onKeyPressed(gui, key, modifier)) {
                    return true;
                }
                if (key == 256) {
                    gui.root.setOverlay(null);
                    return true;
                }
                return false;
            }
        }
    }
}

