/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiCraft;
import me.towdium.jecalculation.gui.guis.GuiMath;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.utils.GuiUtils;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class JecaGui
extends AbstractContainerScreen<JecaContainer> {
    public static final KeyMapping keyOpenGuiCraft = new KeyMapping("jecalculation.key.gui_craft", -1, "jecalculation.key.category");
    public static final KeyMapping keyOpenGuiMath = new KeyMapping("jecalculation.key.gui_math", -1, "jecalculation.key.category");
    public static final int COLOR_GUI_GREY = -6184543;
    public static final int COLOR_TEXT_RED = 0xFF0000;
    public static final int COLOR_TEXT_GREY = 0x404040;
    public static final int COLOR_TEXT_WHITE = 0xFFFFFF;
    public static final boolean ALWAYS_TOOLTIP = false;
    public static final String SEPARATOR = new String();
    public static final boolean IS_OSX = Util.OS.OSX.equals((Object)Util.m_137581_());
    public ILabel hand = ILabel.EMPTY;
    protected static JecaGui last;
    public static JecaGui override;
    protected JecaGui parent;
    protected PoseStack matrix;
    protected final Utilities.OffsetStack itemOffset = new Utilities.OffsetStack();
    protected final boolean isWidget;
    protected boolean preventRecipeScreen = false;
    public IGui root;

    public JecaGui(@Nullable JecaGui parent, IGui root, boolean isWidget) {
        this(parent, false, root, isWidget);
    }

    public JecaGui(@Nullable JecaGui parent, boolean acceptsTransfer, IGui root, boolean isWidget) {
        super((AbstractContainerMenu)(acceptsTransfer ? new ContainerTransfer() : new ContainerNonTransfer()), Utilities.getPlayer().m_150109_(), (Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.root = root;
        this.isWidget = isWidget;
        if (this.f_97732_ != null) {
            ((JecaContainer)this.f_97732_).setGui(this);
        }
    }

    public static void registerEvents() {
        ClientGuiEvent.SET_SCREEN.register(JecaGui::onGuiOpen);
        ClientTooltipEvent.RENDER_PRE.register(JecaGui::onTooltip);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(JecaGui::onFocused);
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register(JecaGui::onMouseScroll);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(JecaGui::onMouseClicked);
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register(JecaGui::onMouseDragged);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(JecaGui::onMouseReleased);
        ClientRawInputEvent.KEY_PRESSED.register(JecaGui::onKeyPressed);
    }

    public void m_6575_(Minecraft minecraft, int width, int height) {
        if (!this.isWidget) {
            super.m_6575_(minecraft, width, height);
            minecraft.f_91068_.m_90926_(true);
            return;
        }
        this.f_96541_ = minecraft;
        this.f_96542_ = minecraft.m_91291_();
        this.f_96547_ = minecraft.f_91062_;
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.m_7856_();
        minecraft.f_91068_.m_90926_(true);
    }

    public void m_7861_() {
        super.m_7861_();
        Objects.requireNonNull(this.f_96541_);
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public static int getMouseX() {
        JecaGui gui = JecaGui.getCurrent();
        Minecraft mc = Objects.requireNonNull(gui.f_96541_, "Internal error");
        int windowWidth = mc.m_91268_().m_85443_();
        if (windowWidth == 0) {
            return 0;
        }
        return (int)mc.f_91067_.m_91589_() * mc.m_91268_().m_85445_() / windowWidth - gui.f_97735_;
    }

    public static int getMouseY() {
        JecaGui gui = JecaGui.getCurrent();
        Minecraft mc = Objects.requireNonNull(gui.f_96541_, "Internal error");
        int windowHeight = mc.m_91268_().m_85444_();
        if (windowHeight == 0) {
            return 0;
        }
        return (int)mc.f_91067_.m_91594_() * mc.m_91268_().m_85446_() / windowHeight - gui.f_97736_;
    }

    public int getGlobalMouseX() {
        Minecraft mc = Objects.requireNonNull(Minecraft.m_91087_(), "Internal error");
        int width = mc.m_91268_().m_85441_();
        if (width == 0) {
            return 0;
        }
        if (IS_OSX) {
            width /= 2;
        }
        return (int)mc.f_91067_.m_91589_() * mc.m_91268_().m_85445_() / width - this.f_97735_;
    }

    public int getGlobalMouseY() {
        Minecraft mc = Objects.requireNonNull(Minecraft.m_91087_(), "Internal error");
        int height = mc.m_91268_().m_85442_();
        if (height == 0) {
            return 0;
        }
        if (IS_OSX) {
            height /= 2;
        }
        return (int)mc.f_91067_.m_91594_() * mc.m_91268_().m_85446_() / height - this.f_97736_;
    }

    public int getGuiLeft() {
        return this.f_97735_;
    }

    public int getGuiTop() {
        return this.f_97736_;
    }

    public int getYSize() {
        return this.f_97727_;
    }

    public static EventResult onFocused(Minecraft client, Screen screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseFocused(gui, xMouse, yMouse, button);
        ILabel e = Utilities.getLabelUnderMouse();
        if (e != ILabel.EMPTY) {
            gui.hand = e;
            gui.preventRecipeScreen = true;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseClicked(Minecraft client, Screen screen, double mouseX, double mouseY, int button) {
        int yMouse;
        int xMouse;
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        if (gui.root.onMouseClicked(gui, xMouse = JecaGui.getMouseX(), yMouse = JecaGui.getMouseY(), button)) {
            return EventResult.interruptFalse();
        }
        if (gui.hand != ILabel.EMPTY) {
            gui.hand = ILabel.EMPTY;
            gui.preventRecipeScreen = false;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult onMouseScroll(Minecraft client, Screen screen, double mouseX, double mouseY, double amount) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        if (amount != 0.0) {
            gui.root.onMouseScroll(gui, xMouse, yMouse, (int)amount);
        }
        return EventResult.pass();
    }

    public static EventResult onMouseReleased(Minecraft minecraft, Screen screen, double mouseX, double mouseY, int button) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseReleased(gui, xMouse, yMouse, button);
        return gui.hand == ILabel.EMPTY ? EventResult.pass() : EventResult.interruptFalse();
    }

    public static EventResult onMouseDragged(Minecraft client, Screen screen, double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        if (!(screen instanceof JecaGui)) {
            return EventResult.pass();
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        gui.root.onMouseDragged(gui, xMouse, yMouse, (int)mouseX2, (int)mouseY2);
        return EventResult.pass();
    }

    public void m_86600_() {
        super.m_86600_();
        this.root.onTick(this);
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Object rep;
        SimpleContainer i = new SimpleContainer(new ItemStack[]{ItemStack.f_41583_});
        Slot s = new Slot((Container)i, 0, 0, 0);
        ILabel l = this.getLabelUnderMouse();
        Object object = rep = l == null ? null : l.getRepresentation();
        if (rep instanceof ItemStack) {
            s.m_5852_((ItemStack)rep);
        }
        return s;
    }

    public static boolean mouseIn(int xPos, int yPos, int xSize, int ySize, int xMouse, int yMouse) {
        return xMouse > xPos && yMouse > yPos && xMouse <= xPos + xSize && yMouse <= yPos + ySize;
    }

    public static void displayGui(IGui root) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s instanceof JecaGui) {
            JecaGui.displayGui(root, true);
        } else {
            JecaGui.displayGui(root, null);
        }
    }

    public static void displayGui(IGui root, @Nullable JecaGui parent) {
        Minecraft mc = Minecraft.m_91087_();
        Screen s = mc.f_91080_;
        JecaGui gui = new JecaGui(parent, root.acceptsTransfer(), root, false);
        if (Utilities.isRecipeScreen(s) || s instanceof ChatScreen) {
            override = gui;
        } else {
            Runnable runnable = () -> {
                root.onVisible(gui);
                last = gui;
                mc.m_91152_((Screen)gui);
            };
            if (Minecraft.m_91087_().m_18695_()) {
                runnable.run();
            } else {
                Minecraft.m_91087_().m_18689_(runnable);
            }
        }
    }

    public static void displayGui(IGui root, boolean updateParent) {
        JecaGui current = JecaGui.getCurrent();
        JecaGui parent = updateParent ? current : current.parent;
        JecaGui.displayGui(root, parent);
    }

    public PoseStack getMatrix() {
        return this.matrix;
    }

    public void setMatrix(PoseStack matrix) {
        this.matrix = matrix;
    }

    public Utilities.OffsetStack getItemOffsetStack() {
        return this.itemOffset;
    }

    public static JecaGui getCurrent() {
        Screen gui = Minecraft.m_91087_().f_91080_;
        JecaGui ret = gui instanceof JecaGui ? (JecaGui)gui : null;
        Objects.requireNonNull(ret);
        return ret;
    }

    public static JecaGui getLast() {
        return last;
    }

    public static void displayParent() {
        JecaGui gui = JecaGui.getCurrent().parent;
        gui.root.onVisible(gui);
        last = gui;
        Minecraft.m_91087_().m_91152_((Screen)gui);
    }

    @Nullable
    public ILabel getLabelUnderMouse() {
        Wrapper<Object> l = new Wrapper<Object>(null);
        this.root.getLabelUnderMouse(this.getGlobalMouseX(), this.getGlobalMouseY(), l);
        return (ILabel)l.value;
    }

    public static EventResult onKeyPressed(Minecraft minecraft, int keyCode, int scanCode, int action, int modifiers) {
        if (keyOpenGuiCraft.m_90857_()) {
            JecaGui.openGuiCraft(null, 0);
        }
        if (keyOpenGuiMath.m_90857_()) {
            JecaGui.openGuiMath(null, 0);
        }
        return EventResult.pass();
    }

    public static EventResult onTooltip(PoseStack poseStack, List<? extends ClientTooltipComponent> components, int x, int y) {
        if (Minecraft.m_91087_().f_91080_ instanceof JecaGui) {
            JecaGui gui = JecaGui.getCurrent();
            return gui.root.onTooltip(gui, x - gui.f_97735_, y - gui.f_97736_, new ArrayList<String>()) ? EventResult.interruptFalse() : EventResult.pass();
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<Screen> onGuiOpen(Screen screen) {
        if (override != null) {
            JecaGui.override.root.onVisible(override);
            last = override;
            JecaGui s = override;
            override = null;
            return CompoundEventResult.interruptTrue((Object)((Object)s));
        }
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof JecaGui) {
            JecaGui gui = (JecaGui)screen2;
            if (gui.preventRecipeScreen && Utilities.isRecipeScreen(screen)) {
                gui.preventRecipeScreen = false;
                return CompoundEventResult.interruptFalse((Object)((Object)gui));
            }
        }
        return CompoundEventResult.pass();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int openGuiMath(@Nullable ItemStack is, int slot) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().m_5661_((Component)Component.m_237115_((String)s), false);
        } else {
            JecaGui.displayGui(new GuiMath(is, slot));
        }
        return ret ? 1 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int openGuiCraft(@Nullable ItemStack is, int slot) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().m_5661_((Component)Component.m_237115_((String)s), false);
        } else {
            JecaGui.displayGui(new GuiCraft(is, slot));
        }
        return ret ? 1 : 0;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.matrix = matrixStack;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        this.root.onDraw(this, mouseX -= this.f_97735_, mouseY -= this.f_97736_);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 80.0);
        this.hand.drawLabel(this, mouseX + this.f_97735_, mouseY + this.f_97736_, true, true);
        matrixStack.m_85849_();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.root.onTooltip(this, mouseX, mouseY, tooltip);
        this.drawHoveringText(matrixStack, tooltip, mouseX + this.f_97735_, mouseY + this.f_97736_, this.f_96547_);
    }

    public void drawHoveringText(PoseStack matrixStack, List<String> textLines, int x, int y, Font font) {
        if (!textLines.isEmpty()) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69482_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 400.0);
            int i = 0;
            int separators = 0;
            for (String s : textLines) {
                int j = this.f_96547_.m_92895_(s);
                if (j > i) {
                    i = j;
                }
                if (s != SEPARATOR) continue;
                ++separators;
            }
            if (textLines.get(textLines.size() - 1) == SEPARATOR) {
                --separators;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8 + (textLines.size() - separators - 1) * 10 + 2 * separators;
            if (l1 + i > this.f_96543_) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.f_96544_) {
                i2 = this.f_96544_ - k - 6;
            }
            this.m_93179_(matrixStack, l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, -267386864, -267386864);
            this.m_93179_(matrixStack, l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.m_93179_(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.m_93179_(matrixStack, l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.m_93179_(matrixStack, l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.m_93179_(matrixStack, l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.m_93179_(matrixStack, l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.m_93179_(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.m_93179_(matrixStack, l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (String s1 : textLines) {
                if (s1 == SEPARATOR) {
                    i2 += 2;
                    continue;
                }
                font.m_92750_(matrixStack, s1, (float)l1, (float)i2, -1);
                i2 += 10;
            }
            matrixStack.m_85849_();
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
        }
    }

    public void drawResource(Resource r, int xPos, int yPos) {
        this.drawResource(r, xPos, yPos, 0xFFFFFF);
    }

    public void drawResource(Resource r, int xPos, int yPos, int color) {
        this.setColor(color);
        RenderSystem.m_157456_((int)0, (ResourceLocation)r.getResourceLocation());
        this.m_93228_(this.matrix, xPos, yPos, r.getXPos(), r.getYPos(), r.getXSize(), r.getYSize());
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int border) {
        this.drawResourceContinuous(r, xPos, yPos, xSize, ySize, border, border, border, border);
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int borderTop, int borderBottom, int borderLeft, int borderRight) {
        GuiUtils.drawContinuousTexturedBox(this.matrix, r.getResourceLocation(), xPos, yPos, r.getXPos(), r.getYPos(), xSize, ySize, r.getXSize(), r.getYSize(), borderTop, borderBottom, borderLeft, borderRight, 0.0f);
    }

    private void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(~(color >> 24) & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void drawFluid(Fluid f, int xPos, int yPos, int xSize, int ySize) {
        TextureAtlasSprite fluidTexture = FluidStackHooks.getStillTexture((Fluid)f);
        if (fluidTexture == null) {
            fluidTexture = FluidStackHooks.getStillTexture((Fluid)Fluids.f_76193_);
        }
        if (fluidTexture == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        this.setColor(FluidStackHooks.getColor((Fluid)f) & 0xFFFFFF);
        JecaGui.m_93200_((PoseStack)this.matrix, (int)xPos, (int)yPos, (int)0, (int)xSize, (int)ySize, (TextureAtlasSprite)fluidTexture);
    }

    public void drawRectangle(int xPos, int yPos, int xSize, int ySize, int color) {
        JecaGui.m_93172_((PoseStack)this.matrix, (int)xPos, (int)yPos, (int)(xPos + xSize), (int)(yPos + ySize), (int)color);
    }

    public int getStringWidth(String s) {
        return this.f_96547_.m_92895_(s);
    }

    public void drawSplitText(float xPos, float yPos, int width, FontType f, String s) {
        this.drawSplitText(xPos, yPos, f, Utilities.I18n.wrap(s, width));
    }

    public void drawSplitText(float xPos, float yPos, FontType f, List<String> ss) {
        this.drawText(xPos, yPos, f, () -> {
            int y = 0;
            for (String i : ss) {
                if (f.shadow) {
                    this.f_96547_.m_92750_(this.matrix, i, 0.0f, (float)y, f.color);
                } else {
                    this.f_96547_.m_92883_(this.matrix, i, 0.0f, (float)y, f.color);
                }
                Objects.requireNonNull(this.f_96547_);
                y += 9 + 1;
            }
        });
    }

    public void drawText(float xPos, float yPos, FontType f, String s) {
        this.drawText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawText(float xPos, float yPos, int width, FontType f, String s) {
        this.drawText(xPos, yPos, f, () -> {
            Object str = s;
            int strWidth = f.getTextWidth((String)str);
            int ellipsisWidth = f.getTextWidth("...");
            if (strWidth > width && strWidth > ellipsisWidth) {
                str = f.trimToWidth((String)str, width - ellipsisWidth).trim() + "...";
            }
            if (f.shadow) {
                this.f_96547_.m_92750_(this.matrix, (String)str, 0.0f, 0.0f, f.color);
            } else {
                this.f_96547_.m_92883_(this.matrix, (String)str, 0.0f, 0.0f, f.color);
            }
        });
    }

    private void drawText(float xPos, float yPos, FontType f, Runnable r) {
        this.getMatrix().m_85836_();
        this.getMatrix().m_85837_((double)xPos, (double)yPos, 200.0);
        if (f.half) {
            this.getMatrix().m_85841_(0.5f, 0.5f, 1.0f);
        }
        r.run();
        this.getMatrix().m_85849_();
    }

    public void drawItemStack(int xPos, int yPos, ItemStack is, boolean centred, boolean hand) {
        if (centred) {
            xPos -= 8;
            yPos -= 8;
        }
        int x = hand ? xPos : this.f_97735_ + xPos;
        int y = hand ? yPos : this.f_97736_ + yPos;
        RenderSystem.m_69482_();
        this.f_96542_.m_115203_(is, x + this.itemOffset.x(), y + this.itemOffset.y());
        this.f_96542_.m_115174_(this.f_96547_, is, this.f_97735_ + xPos, this.f_97736_ + yPos, null);
        RenderSystem.m_69465_();
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
    }

    public boolean m_5534_(char ch, int modifier) {
        return this.root.onChar(this, ch, modifier) || super.m_5534_(ch, modifier);
    }

    public boolean m_7933_(int key, int scan, int modifier) {
        if (key == 256 && this.hand != ILabel.EMPTY) {
            this.hand = ILabel.EMPTY;
        } else if (!this.root.onKeyPressed(this, key, modifier)) {
            if (key == 256 && this.parent != null) {
                JecaGui.displayParent();
            } else {
                return super.m_7933_(key, scan, modifier);
            }
        }
        return true;
    }

    public boolean m_7920_(int key, int scan, int modifier) {
        return this.root.onKeyReleased(this, key, modifier) || super.m_7920_(key, scan, modifier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContainerTransfer
    extends JecaContainer {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContainerNonTransfer
    extends JecaContainer {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class JecaContainer
    extends AbstractContainerMenu {
        JecaGui gui;

        protected JecaContainer() {
            super(null, 0);
        }

        public JecaGui getGui() {
            return this.gui;
        }

        public void setGui(JecaGui gui) {
            this.gui = gui;
        }

        public ItemStack m_7648_(Player player, int index) {
            return null;
        }

        public boolean m_6875_(Player playerIn) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FontType {
        public static final FontType SHADOW = new FontType(0xFFFFFF, true, false, false);
        public static final FontType PLAIN = new FontType(0x404040, false, false, false);
        public static final FontType RAW = new FontType(0x404040, false, false, true);
        public static final FontType HALF = new FontType(0xFFFFFF, true, true, true);
        public int color;
        public boolean shadow;
        public boolean half;
        public boolean raw;
        private final Font font;

        public FontType(int color, boolean shadow, boolean half, boolean raw) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.color = color;
            this.shadow = shadow;
            this.half = half;
            this.raw = raw;
        }

        public int getTextWidth(String s) {
            return (int)Math.ceil((float)this.font.m_92895_(s) * (this.half ? 0.5f : 1.0f));
        }

        public int getTextHeight() {
            Objects.requireNonNull(this.font);
            return (int)Math.ceil(9.0f * (this.half ? 0.5f : 1.0f));
        }

        public String trimToWidth(String s, int i) {
            return this.font.m_92834_(s, i * (this.half ? 2 : 1));
        }
    }
}

