/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.world.tree.decorator.ReduxTreeDecorators;

public class EnchantedVineDecorator
extends TreeDecorator {
    public static final Codec<EnchantedVineDecorator> CODEC = RecordCodecBuilder.create(vines -> vines.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_min").forGetter(config -> Float.valueOf(config.probabilityMin)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_max").forGetter(config -> Float.valueOf(config.probabilityMax)), (App)BlockStateProvider.f_68747_.fieldOf("plant_body_provider").forGetter(config -> config.bodyBlock), (App)BlockStateProvider.f_68747_.fieldOf("plant_head_provider").forGetter(config -> config.headBlock), (App)IntProvider.m_146545_((int)1, (int)128).fieldOf("length_min").forGetter(config -> config.lengthMin), (App)IntProvider.m_146545_((int)1, (int)128).fieldOf("length_max").forGetter(config -> config.lengthMax), (App)AbstractCondition.CODEC.optionalFieldOf("condition").forGetter(config -> config.condition)).apply((Applicative)vines, EnchantedVineDecorator::new));
    private final float probabilityMin;
    private final float probabilityMax;
    private final BlockStateProvider bodyBlock;
    private final BlockStateProvider headBlock;
    private final IntProvider lengthMin;
    private final IntProvider lengthMax;
    private final Optional<AbstractCondition<?>> condition;

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ReduxTreeDecorators.ENCHANTED_VINES.get();
    }

    public EnchantedVineDecorator(float pProbabilityMin, float pProbabilityMax, BlockStateProvider pBodyBlock, BlockStateProvider pHeadBlock, IntProvider pLengthMin, IntProvider pLengthMax, Optional<AbstractCondition<?>> condition) {
        this.probabilityMin = pProbabilityMin;
        this.probabilityMax = pProbabilityMax;
        this.bodyBlock = pBodyBlock;
        this.headBlock = pHeadBlock;
        this.lengthMin = pLengthMin;
        this.lengthMax = pLengthMax;
        this.condition = condition;
    }

    public void m_214187_(TreeDecorator.Context pContext) {
        if (this.condition.isEmpty() || this.condition.get().isConditionMet()) {
            float dist;
            float pyth;
            RandomSource randomsource = pContext.m_226067_();
            float maxDistance = 0.0f;
            BlockPos trunk = (BlockPos)pContext.m_226068_().get(0);
            for (BlockPos leafPos : pContext.m_226069_()) {
                pyth = (trunk.m_123341_() - leafPos.m_123341_()) * (trunk.m_123341_() - leafPos.m_123341_()) + (trunk.m_123343_() - leafPos.m_123343_()) * (trunk.m_123343_() - leafPos.m_123343_());
                dist = Mth.m_14116_((float)pyth);
                if (!(dist > maxDistance)) continue;
                maxDistance = dist;
            }
            for (BlockPos leafPos : pContext.m_226069_()) {
                BlockPos blockpos;
                pyth = (trunk.m_123341_() - leafPos.m_123341_()) * (trunk.m_123341_() - leafPos.m_123341_()) + (trunk.m_123343_() - leafPos.m_123343_()) * (trunk.m_123343_() - leafPos.m_123343_());
                dist = Mth.m_14116_((float)pyth);
                float interpolate = maxDistance != 0.0f ? dist / maxDistance : 1.0f;
                float probability = Mth.m_14179_((float)interpolate, (float)this.probabilityMin, (float)this.probabilityMax);
                int length = Mth.m_14167_((float)Mth.m_14179_((float)interpolate, (float)this.lengthMin.m_214085_(pContext.m_226067_()), (float)this.lengthMax.m_214085_(pContext.m_226067_())));
                if (!(randomsource.m_188501_() < probability) || !pContext.m_226059_(blockpos = leafPos.m_7495_())) continue;
                this.addVine(blockpos, pContext, length);
            }
        }
    }

    private void addVine(BlockPos pPos, TreeDecorator.Context pContext, int length) {
        BlockPos placement;
        for (int i = 1; i <= length && pContext.m_226059_(placement = pPos.m_7918_(0, -(i - 1), 0)) && !pContext.m_226058_().m_7433_(placement, state -> state.m_204336_(ReduxTags.Blocks.ENCHANTED_VINES_SKIP_PLACEMENT)); ++i) {
            if (!pContext.m_226059_(placement.m_7495_()) || i >= length || pContext.m_226058_().m_7433_(placement.m_7495_(), state -> state.m_204336_(ReduxTags.Blocks.ENCHANTED_VINES_SKIP_PLACEMENT))) {
                pContext.m_226061_(placement, this.headBlock.m_213972_(pContext.m_226067_(), pPos));
                break;
            }
            pContext.m_226061_(placement, this.bodyBlock.m_213972_(pContext.m_226067_(), pPos));
        }
    }

    private void placeBlockAt(TreeDecorator.Context context, BlockPos pos, BlockState state) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)context.m_226058_(), (BlockPos)pos) && !TreeFeature.m_67272_((LevelSimulatedReader)context.m_226058_(), (BlockPos)pos.m_7495_())) {
            context.m_226061_(pos, state);
        }
    }
}

