/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.level.WorldgenUtil;
import net.zepalesque.redux.world.tree.decorator.ReduxTreeDecorators;

public class BlightwillowRootsTrunkDecorator
extends TreeDecorator {
    public static final Codec<BlightwillowRootsTrunkDecorator> CODEC = RecordCodecBuilder.create(vines -> vines.group((App)BlockStateProvider.f_68747_.fieldOf("root_block").forGetter(config -> config.rootBlock), (App)BlockStateProvider.f_68747_.fieldOf("wall_block").forGetter(config -> config.wallBlock), (App)IntProvider.f_146531_.fieldOf("root_height").forGetter(config -> config.rootHeight)).apply((Applicative)vines, BlightwillowRootsTrunkDecorator::new));
    private final BlockStateProvider rootBlock;
    private final BlockStateProvider wallBlock;
    private final IntProvider rootHeight;

    public BlightwillowRootsTrunkDecorator(BlockStateProvider rootBlock, BlockStateProvider wallBlock, IntProvider rootHeight) {
        this.rootBlock = rootBlock;
        this.wallBlock = wallBlock;
        this.rootHeight = rootHeight;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ReduxTreeDecorators.BLIGHTWILLOW_ROOTS.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        if (((Boolean)ReduxConfig.COMMON.wall_roots.get()).booleanValue()) {
            BlockPos basePos = (BlockPos)context.m_226068_().get(1);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int heightBelowLeaves = context.m_226068_().size() - 6;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                BlockPos immutable;
                int i;
                BlockPos startPos = basePos.m_121945_(d);
                int height = this.rootHeight.m_214085_(context.m_226067_());
                for (i = 0; i < height; ++i) {
                    mutable.m_122154_((Vec3i)startPos, 0, i, 0);
                    immutable = mutable.m_7949_();
                    this.placeBlockAt(context, immutable, this.rootBlock.m_213972_(context.m_226067_(), immutable));
                }
                for (i = height; i < heightBelowLeaves; ++i) {
                    mutable.m_122154_((Vec3i)startPos, 0, i, 0);
                    immutable = mutable.m_7949_();
                    this.placeBlockAt(context, immutable, (BlockState)this.wallBlock.m_213972_(context.m_226067_(), immutable).m_61124_(WorldgenUtil.getWallSide(d.m_122424_()), (Comparable)WallSide.TALL));
                }
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context context, BlockPos pos, BlockState state) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)context.m_226058_(), (BlockPos)pos) && !TreeFeature.m_67272_((LevelSimulatedReader)context.m_226058_(), (BlockPos)pos.m_7495_())) {
            context.m_226061_(pos, state);
        }
    }
}

