/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.math.MathUtil;

public class CloudLayerFeature
extends Feature<Config> {
    public static final PerlinSimplexNoise base_noise = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(42L), List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
    public static final PerlinSimplexNoise y_offset = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(95L), List.of(Integer.valueOf(0), Integer.valueOf(1)));

    public CloudLayerFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int chunkX = context.m_159777_().m_123341_() - context.m_159777_().m_123341_() % 16;
        int chunkZ = context.m_159777_().m_123343_() - context.m_159777_().m_123343_() % 16;
        float min = ((Double)ReduxConfig.COMMON.cloud_layer_threshold_min.get()).floatValue() / 2.0f;
        float max = ((Double)ReduxConfig.COMMON.cloud_layer_threshold_max.get()).floatValue() / 2.0f;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double scale = ((Config)context.m_159778_()).scaleXZ() * 0.00375;
                int xCoord = chunkX + x;
                int zCoord = chunkZ + z;
                double base = base_noise.m_75449_((double)xCoord * scale, (double)zCoord * scale, false);
                double main = Mth.m_14112_((double)base, (double)min, (double)max);
                double yOffset = y_offset.m_75449_((double)xCoord * scale * 0.75, (double)zCoord * scale * 0.75, false);
                float offs = (float)Mth.m_14139_((double)Mth.m_14112_((double)yOffset, (double)-0.5, (double)0.5), (double)0.0, (double)10.0);
                if (!(main >= 0.0)) continue;
                float delta = MathUtil.costrp((float)Mth.m_14008_((double)main, (double)0.0, (double)1.0), 0.0f, 1.0f);
                float blocksUp = Mth.m_14179_((float)delta, (float)0.0f, (float)5.0f) + offs;
                float blocksDown = Mth.m_14179_((float)delta, (float)0.0f, (float)4.0f) - offs;
                for (int i = Mth.m_14143_((float)(-blocksDown)); i <= Mth.m_14143_((float)blocksUp); ++i) {
                    int y = Mth.m_14045_((int)(((Config)context.m_159778_()).yLevel() + i), (int)context.m_159774_().m_141937_(), (int)context.m_159774_().m_151558_());
                    BlockPos pos = new BlockPos(xCoord, y, zCoord);
                    if (!((Config)context.m_159778_()).predicate().test((Object)context.m_159774_(), (Object)pos)) continue;
                    this.m_5974_((LevelWriter)context.m_159774_(), pos, ((Config)context.m_159778_()).block().m_213972_(context.m_225041_(), pos));
                }
            }
        }
        return false;
    }

    public record Config(BlockStateProvider block, BlockPredicate predicate, int yLevel, double scaleXZ) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(Config::block), (App)BlockPredicate.f_190392_.fieldOf("predicate").forGetter(Config::predicate), (App)Codec.INT.fieldOf("base_height").forGetter(Config::yLevel), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(Config::scaleXZ)).apply((Applicative)builder, Config::new));
    }
}

