/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.util.function.CodecPredicates;
import net.zepalesque.redux.world.biome.modifier.ReduxBiomeModifierCodecs;

public record MusicModifier(HolderSet<Biome> biomes, Optional<SoundEvent> event, Optional<CodecPredicates.DualInt> delay, Optional<Boolean> replaceCurrentMusic, Optional<CodecPredicates.Sound> soundPredicate, Optional<CodecPredicates.DualInt> delayPredicate, Optional<CodecPredicates.Bool> replacePredicate) implements BiomeModifier
{
    public static Codec<CodecPredicates.DualInt> DELAY = CodecPredicates.DualInt.createCodec("min", "max");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.biomes.m_203333_(biome) && ((Biome)biome.get()).m_47566_().isPresent()) {
            builder.getSpecialEffects().m_48021_(this.processMusic((Music)((Biome)biome.get()).m_47566_().get()));
        }
    }

    private Music processMusic(Music music) {
        if (this.soundPredicate.isEmpty() && this.delay.isEmpty() && this.replaceCurrentMusic.isEmpty()) {
            return music;
        }
        SoundEvent event = music.m_11631_();
        if (this.event.isPresent() && (this.soundPredicate.isEmpty() || this.soundPredicate.get().test(music.m_11631_()))) {
            event = this.event.get();
        }
        int minDelay = music.m_11636_();
        int maxDelay = music.m_11639_();
        if ((this.delayPredicate.isEmpty() || this.delayPredicate.get().test(music.m_11636_(), music.m_11639_())) && this.delay.isPresent()) {
            minDelay = this.delay.get().arg1;
            maxDelay = this.delay.get().arg2;
        }
        boolean replace = music.m_11642_();
        if (this.replaceCurrentMusic.isPresent() && (this.replacePredicate.isEmpty() || this.replacePredicate.get().test(music.m_11642_()))) {
            replace = this.replaceCurrentMusic.get();
        }
        return new Music(event, minDelay, maxDelay, replace);
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ReduxBiomeModifierCodecs.MUSIC.get();
    }
}

