/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.zepalesque.redux.recipe.StackingRecipe;
import net.zepalesque.redux.util.json.CommonJsonUtil;

public class StackingRecipeSerializer<T extends StackingRecipe>
implements RecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public StackingRecipeSerializer(CookieBaker<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
        }
        JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (!json.get("result").isJsonObject()) {
            throw new JsonSyntaxException("Expected result to be object");
        }
        JsonObject resultObject = json.getAsJsonObject("result");
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultObject);
        int infusionAmount = CommonJsonUtil.getIntOr("infusion_increase", json, 0);
        return this.factory.create(id, ingredient, result, infusionAmount);
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        int infusionAmount = buffer.readInt();
        return this.factory.create(id, ingredient, result, infusionAmount);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        recipe.getIngredient().m_43923_(buffer);
        buffer.m_130055_(recipe.getResult());
        buffer.writeInt(recipe.infusionAmount());
    }

    public static interface CookieBaker<T extends StackingRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, ItemStack var3, int var4);
    }
}

