/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.zepalesque.redux.recipe.AbstractStackingRecipe;

public class StackingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int infusionAmount;
    private final RecipeSerializer<? extends AbstractStackingRecipe> serializer;
    @Nullable
    private ResourceLocation function;

    public StackingRecipeBuilder(Item result, Ingredient ingredient, int infusionAmount, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
        this.result = result;
        this.ingredient = ingredient;
        this.infusionAmount = infusionAmount;
        this.serializer = serializer;
    }

    public static StackingRecipeBuilder recipe(Ingredient ingredient, Item result, int infusionAmount, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
        return new StackingRecipeBuilder(result, ingredient, infusionAmount, serializer);
    }

    public static StackingRecipeBuilder recipe(Ingredient ingredient, Item result, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
        return StackingRecipeBuilder.recipe(ingredient, result, 0, serializer);
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public RecipeBuilder function(@Nullable ResourceLocation function) {
        this.function = function;
        return this;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public RecipeSerializer<? extends AbstractStackingRecipe> getSerializer() {
        return this.serializer;
    }

    public Item m_142372_() {
        return this.result;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation id) {
        finishedRecipeConsumer.accept(new Result(id, this.ingredient, this.result, this.infusionAmount, this.serializer));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final int infusionAmount;
        private final RecipeSerializer<? extends AbstractStackingRecipe> serializer;

        public Result(ResourceLocation id, Ingredient ingredient, Item result, int infusionAmount, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.infusionAmount = infusionAmount;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            json.add("result", (JsonElement)result);
            if (this.infusionAmount != 0) {
                json.addProperty("infusion_increase", (Number)this.infusionAmount);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

