/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.loot.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.registries.ForgeRegistries;

public class RawOreModifier
extends LootModifier {
    private static final Codec<LootItemFunction[]> LOOT_FUNCTIONS_CODEC = Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            LootItemFunction[] functions = (LootItemFunction[])LootModifierManager.GSON_INSTANCE.fromJson(IGlobalLootModifier.getJson((Dynamic)d), LootItemFunction[].class);
            return DataResult.success((Object)functions);
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot functions", (Throwable)e);
            return DataResult.error((String)e.getMessage());
        }
    }, functions -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(functions);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot functions", (Throwable)e);
            return DataResult.error((String)e.getMessage());
        }
    });
    public static final Codec<RawOreModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(modifier -> modifier.toRemove), (App)ItemStack.f_41582_.fieldOf("added_item").forGetter(modifier -> modifier.rawOre), (App)LOOT_FUNCTIONS_CODEC.fieldOf("functions").forGetter(modifier -> modifier.functions), (App)LootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(modifier -> modifier.conditions)).apply((Applicative)instance, RawOreModifier::new));
    private final Item toRemove;
    private final LootItemFunction[] functions;
    private final ItemStack rawOre;

    public RawOreModifier(Item toRemove, ItemStack rawOre, LootItemFunction[] functions, LootItemCondition[] conditions) {
        super(conditions);
        this.toRemove = toRemove;
        this.rawOre = rawOre;
        this.functions = functions;
    }

    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> lootStacks, LootContext context) {
        lootStacks.removeIf(itemStack -> itemStack.m_150930_(this.toRemove));
        ItemStack i = this.rawOre;
        for (LootItemFunction function : this.functions) {
            i = (ItemStack)function.apply((Object)this.rawOre, (Object)context);
        }
        lootStacks.add((Object)i);
        return lootStacks;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

