/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.loot.condition.ReduxLootConditions;

public class DataLootCondition
implements LootItemCondition {
    private final AbstractCondition condition;

    public DataLootCondition(AbstractCondition condition) {
        this.condition = condition;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ReduxLootConditions.DATA_CONDITION.get();
    }

    public boolean test(LootContext lootContext) {
        if (this.condition != null) {
            return this.condition.isConditionMet();
        }
        return true;
    }

    public static LootItemCondition.Builder conditionOf(AbstractCondition condition) {
        return () -> new DataLootCondition(condition);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<DataLootCondition> {
        public void serialize(JsonObject json, DataLootCondition instance, JsonSerializationContext context) {
            DataResult result = AbstractCondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)instance.condition);
            result.resultOrPartial(errorMessage -> Redux.LOGGER.warn("Could not write DataLootCondition with id {} - error: {}", (Object)"data_loot_condition", errorMessage)).ifPresent(jsonElement -> json.add("data_loot_condition", jsonElement));
        }

        public DataLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            JsonElement element = json.get("data_loot_condition");
            Optional optional = AbstractCondition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(errorMessage -> Redux.LOGGER.warn("Could not parse DataRecipeCondition from json with id {} - error: {}", (Object)"data_loot_condition", errorMessage));
            if (optional.isPresent()) {
                return new DataLootCondition((AbstractCondition)optional.get());
            }
            throw new JsonSyntaxException("Failed to parse data condition json!");
        }
    }
}

