/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.hook;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.monster.Swet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.zepalesque.redux.capability.swet.SwetMass;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.entity.ai.goal.HuntNoConsumeGoal;
import net.zepalesque.redux.entity.ai.target.FollowUnabsorbedTargetGoal;

public class SwetHooks {
    protected static Map<EntityType<?>, Item> PARTICLE_ITEM_MAP = new HashMap();

    public static void modifySwetAI(Swet swet) {
        WrappedGoal[] toRemove = new WrappedGoal[2];
        swet.f_21345_.m_148105_().forEach(goal -> {
            if (goal.m_26015_().getClass().equals(Swet.ConsumeGoal.class) && goal.m_26012_() == 0) {
                toRemove[0] = goal;
            }
            if (goal.m_26015_().getClass().equals(Swet.HuntGoal.class) && goal.m_26012_() == 1) {
                toRemove[1] = goal;
            }
        });
        if (toRemove[0] != null && toRemove[1] != null) {
            swet.f_21345_.m_148105_().removeIf(wrappedGoal -> wrappedGoal == toRemove[0] || wrappedGoal == toRemove[1]);
        }
        swet.f_21346_.m_148096_();
        swet.f_21346_.m_25352_(1, new FollowUnabsorbedTargetGoal<Player>((Mob)swet, Player.class, 10, true, false, player -> Math.abs(player.m_20186_() - swet.m_20186_()) <= 4.0 && !FollowUnabsorbedTargetGoal.withinAbsorbingRange((Entity)swet, (Entity)player)));
        swet.f_21345_.m_25352_(1, (Goal)new HuntNoConsumeGoal(swet));
    }

    public static void swetTick(Swet swet) {
        SwetMass.get(swet).ifPresent(SwetMass::tick);
    }

    public static double getTrueScale(Swet swet) {
        int scaleIndex = swet.m_33632_();
        float waterScale = 1.0f - swet.getWaterDamageScale();
        return scaleIndex <= 0 ? (double)waterScale : (1.0 + 0.5 * (double)(scaleIndex - 1)) * (double)waterScale;
    }

    public static double getAbsorbVectorScale(Swet swet) {
        return SwetHooks.getTrueScale(swet);
    }

    public static boolean canAbsorbEntities(Swet swet) {
        return SwetHooks.getTrueScale(swet) > 1.1;
    }

    public static boolean canDamageEntities(Swet swet) {
        return SwetHooks.getTrueScale(swet) > 2.1;
    }

    public static boolean canGrow(Swet swet, ItemStack stack) {
        SpawnEggItem spawnEggItem;
        Item item;
        boolean bl = stack.m_204117_(AetherTags.Items.SWET_BALLS) ? swet.m_33632_() < 8 : (item = stack.m_41720_()) instanceof SpawnEggItem && (spawnEggItem = (SpawnEggItem)item).m_43228_(stack.m_41783_()) == swet.m_6095_() && swet.m_33632_() < 16;
        return bl;
    }

    public static boolean canBeControlled(Swet swet) {
        return SwetHooks.getTrueScale(swet) > 1.1;
    }

    public static float getDamage(Swet swet) {
        return ((float)swet.m_33632_() + Mth.m_14116_((float)swet.m_33632_())) * 0.25f * (1.0f - swet.getWaterDamageScale());
    }

    public static void registerParticle(EntityType<?> type, Item particle) {
        PARTICLE_ITEM_MAP.put(type, particle);
    }

    @Nullable
    public static ParticleOptions getSquelchParticles(Swet swet) {
        return PARTICLE_ITEM_MAP.containsKey(swet.m_6095_()) ? new ItemParticleOption((ParticleType)ReduxParticleTypes.RANDOM_MOVEMENT_ITEM.get(), new ItemStack((ItemLike)PARTICLE_ITEM_MAP.get(swet.m_6095_()))) : null;
    }
}

