/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.hook;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.data.resource.biome.registry.ReduxBiomes;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.item.ReduxItems;

public class MappingsHooks {
    public static final Map<String, WoodHandler> WOOD_TYPES = new ImmutableMap.Builder().put((Object)"prismatic", (Object)Redux.WoodHandlers.FIELDSPROOT).put((Object)"fieldsprout", (Object)Redux.WoodHandlers.FIELDSPROOT).put((Object)"springshroom", (Object)Redux.WoodHandlers.JELLYSHROOM).build();
    public static final Map<ResourceLocation, Supplier<? extends ItemLike>> ITEMS = MappingsHooks.createItemMap();
    public static final Map<ResourceLocation, Supplier<? extends Block>> BLOCKS = MappingsHooks.createBlockMap();
    public static final Map<ResourceLocation, ResourceKey<Biome>> BIOMES = MappingsHooks.createBiomeMap();
    public static final Map<ResourceLocation, Supplier<? extends EntityType<?>>> ENTITIES = MappingsHooks.createEntityMap();

    private static Map<ResourceLocation, Supplier<? extends ItemLike>> createItemMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        WOOD_TYPES.forEach((s, w) -> MappingsHooks.woodItems(s, w, (ImmutableMap.Builder<ResourceLocation, Supplier<? extends ItemLike>>)builder));
        builder.put((Object)Redux.locate("blighted_aether_grass_block"), (Object)AetherBlocks.AETHER_GRASS_BLOCK);
        builder.put((Object)Redux.locate("frosted_aether_grass_block"), (Object)AetherBlocks.AETHER_GRASS_BLOCK);
        builder.put((Object)Redux.locate("aevelium"), ReduxBlocks.AVELIUM);
        builder.put((Object)Redux.locate("aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("blighted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("frosted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("enchanted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("aevelium_growth"), ReduxBlocks.AVELIUM_ROOTS);
        builder.put((Object)Redux.locate("aevelium_sprouts"), ReduxBlocks.AVELIUM_SPROUTS);
        builder.put((Object)Redux.locate("flowering_fieldsprout_leaves"), ReduxBlocks.FIELDSPROOT_LEAVES);
        builder.put((Object)Redux.locate("flowering_fieldsprout_sapling"), ReduxBlocks.FIELDSPROOT_SAPLING);
        builder.put((Object)Redux.locate("blightberry_bush"), ReduxBlocks.ZANBERRY_BUSH);
        builder.put((Object)Redux.locate("blightberry_bush_stem"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_berry_bush"), ReduxBlocks.ZANBERRY_BUSH);
        builder.put((Object)Redux.locate("chromatic_berry_bush_stem"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_shrub"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_leaves"), (Object)AetherBlocks.SKYROOT_LEAVES);
        builder.put((Object)Redux.locate("chromatic_berry_leaves"), (Object)AetherBlocks.SKYROOT_LEAVES);
        builder.put((Object)Redux.locate("springshroom_cap_block"), ReduxBlocks.JELLYSHROOM_JELLY_BLOCK);
        builder.put((Object)Redux.locate("springshroom_spores"), ReduxBlocks.JELLYSHROOM_JELLY_BLOCK);
        builder.put((Object)Redux.locate("springshroom"), ReduxBlocks.JELLYSHROOM);
        builder.put((Object)Redux.locate("pink_prismatic_leaf_pile"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("teal_prismatic_leaf_pile"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("pink_prismatic_petals"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("teal_prismatic_petals"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("splitbloom"), ReduxBlocks.IRIDIA);
        builder.put((Object)Redux.locate("vallyx"), (Object)AetherBlocks.PURPLE_FLOWER);
        builder.put((Object)Redux.locate("sweetblossom"), ReduxBlocks.THERATIP);
        builder.put((Object)Redux.locate("glowsprouts"), ReduxBlocks.LUXWEED);
        builder.put((Object)Redux.locate("blighted_fungi"), ReduxBlocks.CORRUPTED_VINES);
        builder.put((Object)Redux.locate("thorncap"), ReduxBlocks.CORRUPTED_VINES);
        builder.put((Object)Redux.locate("frostbud"), ReduxBlocks.DAGGERBLOOM);
        builder.put((Object)Redux.locate("spikespring"), ReduxBlocks.DAGGERBLOOM);
        builder.put((Object)Redux.locate("frosted_fern"), ReduxBlocks.SPLITFERN);
        builder.put((Object)Redux.locate("frosted_purple_flower"), (Object)AetherBlocks.PURPLE_FLOWER);
        builder.put((Object)Redux.locate("gilded_white_flower"), ReduxBlocks.ENCHANTED_WHITE_FLOWER);
        builder.put((Object)Redux.locate("xaelia_flowers"), ReduxBlocks.XAELIA_PATCH);
        builder.put((Object)Redux.locate("vitrium"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("vitrium_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("vitrium_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("vitrium_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("vitrium_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("vitrium_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("vitrium_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("vitrium_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("volitite"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("volitite_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("volitite_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("volitite_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("volitite_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("volitite_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("volitite_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("volitite_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("agiosite"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("agiosite_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("agiosite_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("agiosite_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("agiosite_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("agiosite_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("agiosite_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("agiosite_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("gilded_skyroot_leaves"), ReduxBlocks.GILDED_OAK_LEAVES);
        builder.put((Object)Redux.locate("gilded_skyroot_sapling"), ReduxBlocks.GILDED_OAK_SAPLING);
        builder.put((Object)Redux.locate("skyroot_sap"), (Object)AetherItems.AMBROSIUM_SHARD);
        builder.put((Object)Redux.locate("blightberry"), ReduxItems.ZANBERRY);
        builder.put((Object)Redux.locate("prismatic_raspberry"), ReduxItems.ZANBERRY);
        builder.put((Object)Redux.locate("chromatic_raspberry"), ReduxItems.ZANBERRY);
        builder.put((Object)Redux.locate("chromaberry"), ReduxItems.ZANBERRY);
        builder.put((Object)Redux.locate("glowbuds"), ReduxItems.BLIGHTED_SPORES);
        builder.put((Object)Redux.locate("luxbuds"), ReduxItems.BLIGHTED_SPORES);
        builder.put((Object)Redux.locate("cockatrice_rib"), () -> Items.f_42500_);
        builder.put((Object)Redux.locate("bundle_of_aether_grass"), ReduxItems.BUNDLE_OF_WYNDSPROUTS);
        builder.put((Object)Redux.locate("oats"), ReduxItems.WYNDSPROUT_SEEDS);
        builder.put((Object)Redux.locate("quickroot"), () -> Blocks.f_152548_);
        builder.put((Object)Redux.locate("oat_muffin"), ReduxItems.WYNDSPROUT_BAGEL);
        builder.put((Object)Redux.locate("mini_pancake"), ReduxItems.BLUEBERRY_BAGEL);
        builder.put((Object)Redux.locate("bittersweet_charm"), (Object)AetherItems.GOLDEN_PENDANT);
        builder.put((Object)Redux.locate("phoenix_ring"), ReduxItems.SOLAR_EMBLEM);
        builder.put((Object)Redux.locate("spectral_dart_shooter"), ReduxItems.VERIDIUM_DART_SHOOTER);
        builder.put((Object)Redux.locate("spectral_dart"), ReduxItems.VERIDIUM_DART);
        return builder.build();
    }

    private static Map<ResourceLocation, Supplier<? extends Block>> createBlockMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        WOOD_TYPES.forEach((s, w) -> MappingsHooks.woodBlocks(s, w, (ImmutableMap.Builder<ResourceLocation, Supplier<? extends Block>>)builder));
        builder.put((Object)Redux.locate("blighted_aether_grass_block"), (Object)AetherBlocks.AETHER_GRASS_BLOCK);
        builder.put((Object)Redux.locate("frosted_aether_grass_block"), (Object)AetherBlocks.AETHER_GRASS_BLOCK);
        builder.put((Object)Redux.locate("arctic_aether_grass_block"), (Object)AetherBlocks.AETHER_GRASS_BLOCK);
        builder.put((Object)Redux.locate("aevelium"), ReduxBlocks.AVELIUM);
        builder.put((Object)Redux.locate("aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("blighted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("frosted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("arctic_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("enchanted_aether_grass"), ReduxBlocks.SHORT_AETHER_GRASS);
        builder.put((Object)Redux.locate("aevelium_growth"), ReduxBlocks.AVELIUM_ROOTS);
        builder.put((Object)Redux.locate("potted_aevelium_growth"), ReduxBlocks.POTTED_AVELIUM_ROOTS);
        builder.put((Object)Redux.locate("aevelium_sprouts"), ReduxBlocks.AVELIUM_SPROUTS);
        builder.put((Object)Redux.locate("potted_aevelium_sprouts"), ReduxBlocks.AVELIUM_SPROUTS);
        builder.put((Object)Redux.locate("flowering_fieldsprout_leaves"), ReduxBlocks.FIELDSPROOT_LEAVES);
        builder.put((Object)Redux.locate("flowering_fieldsprout_sapling"), ReduxBlocks.FIELDSPROOT_SAPLING);
        builder.put((Object)Redux.locate("potted_flowering_fieldsprout_sapling"), ReduxBlocks.POTTED_FIELDSPROOT_SAPLING);
        builder.put((Object)Redux.locate("blightberry_bush"), ReduxBlocks.ZANBERRY_BUSH);
        builder.put((Object)Redux.locate("blightberry_bush_stem"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_berry_bush"), ReduxBlocks.ZANBERRY_BUSH);
        builder.put((Object)Redux.locate("chromatic_berry_bush_stem"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_shrub"), ReduxBlocks.ZANBERRY_BUSH_STEM);
        builder.put((Object)Redux.locate("chromatic_leaves"), (Object)AetherBlocks.SKYROOT_LEAVES);
        builder.put((Object)Redux.locate("chromatic_berry_leaves"), (Object)AetherBlocks.SKYROOT_LEAVES);
        builder.put((Object)Redux.locate("springshroom_cap_block"), ReduxBlocks.JELLYSHROOM_JELLY_BLOCK);
        builder.put((Object)Redux.locate("springshroom_spores"), ReduxBlocks.JELLYSHROOM_JELLY_BLOCK);
        builder.put((Object)Redux.locate("springshroom"), ReduxBlocks.JELLYSHROOM);
        builder.put((Object)Redux.locate("potted_springshroom"), ReduxBlocks.POTTED_JELLYSHROOM);
        builder.put((Object)Redux.locate("pink_prismatic_leaf_pile"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("teal_prismatic_leaf_pile"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("pink_prismatic_petals"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("teal_prismatic_petals"), ReduxBlocks.FIELDSPROOT_PETALS);
        builder.put((Object)Redux.locate("splitbloom"), ReduxBlocks.IRIDIA);
        builder.put((Object)Redux.locate("potted_splitbloom"), ReduxBlocks.POTTED_IRIDIA);
        builder.put((Object)Redux.locate("vallyx"), (Object)AetherBlocks.PURPLE_FLOWER);
        builder.put((Object)Redux.locate("potted_vallyx"), (Object)AetherBlocks.POTTED_PURPLE_FLOWER);
        builder.put((Object)Redux.locate("sweetblossom"), ReduxBlocks.THERATIP);
        builder.put((Object)Redux.locate("potted_sweetblossom"), ReduxBlocks.POTTED_THERATIP);
        builder.put((Object)Redux.locate("frosted_purple_flower"), (Object)AetherBlocks.PURPLE_FLOWER);
        builder.put((Object)Redux.locate("potted_frosted_purple_flower"), (Object)AetherBlocks.POTTED_PURPLE_FLOWER);
        builder.put((Object)Redux.locate("gilded_white_flower"), ReduxBlocks.ENCHANTED_WHITE_FLOWER);
        builder.put((Object)Redux.locate("potted_gilded_white_flower"), (Object)AetherBlocks.POTTED_WHITE_FLOWER);
        builder.put((Object)Redux.locate("blighted_fungi"), ReduxBlocks.CORRUPTED_VINES);
        builder.put((Object)Redux.locate("potted_blighted_fungi"), () -> Blocks.f_50276_);
        builder.put((Object)Redux.locate("thorncap"), ReduxBlocks.CORRUPTED_VINES);
        builder.put((Object)Redux.locate("potted_thorncap"), () -> Blocks.f_50276_);
        builder.put((Object)Redux.locate("frostbud"), ReduxBlocks.DAGGERBLOOM);
        builder.put((Object)Redux.locate("potted_frostbud"), ReduxBlocks.POTTED_DAGGERBLOOM);
        builder.put((Object)Redux.locate("spikespring"), ReduxBlocks.DAGGERBLOOM);
        builder.put((Object)Redux.locate("potted_spikespring"), ReduxBlocks.POTTED_DAGGERBLOOM);
        builder.put((Object)Redux.locate("frosted_fern"), ReduxBlocks.SPLITFERN);
        builder.put((Object)Redux.locate("potted_frosted_fern"), ReduxBlocks.POTTED_SPLITFERN);
        builder.put((Object)Redux.locate("glowsprouts"), ReduxBlocks.LUXWEED);
        builder.put((Object)Redux.locate("potted_glowsprouts"), ReduxBlocks.POTTED_LUXWEED);
        builder.put((Object)Redux.locate("xaelia_flowers"), ReduxBlocks.XAELIA_PATCH);
        builder.put((Object)Redux.locate("vitrium"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("vitrium_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("vitrium_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("vitrium_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("vitrium_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("vitrium_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("vitrium_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("vitrium_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("volitite"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("volitite_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("volitite_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("volitite_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("volitite_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("volitite_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("volitite_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("volitite_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("agiosite"), ReduxBlocks.SENTRITE);
        builder.put((Object)Redux.locate("agiosite_stairs"), ReduxBlocks.SENTRITE_STAIRS);
        builder.put((Object)Redux.locate("agiosite_slab"), ReduxBlocks.SENTRITE_SLAB);
        builder.put((Object)Redux.locate("agiosite_wall"), ReduxBlocks.SENTRITE_WALL);
        builder.put((Object)Redux.locate("agiosite_bricks"), ReduxBlocks.SENTRITE_BRICKS);
        builder.put((Object)Redux.locate("agiosite_brick_stairs"), ReduxBlocks.SENTRITE_BRICK_STAIRS);
        builder.put((Object)Redux.locate("agiosite_brick_slab"), ReduxBlocks.SENTRITE_BRICK_SLAB);
        builder.put((Object)Redux.locate("agiosite_brick_wall"), ReduxBlocks.SENTRITE_BRICK_WALL);
        builder.put((Object)Redux.locate("quickroots"), () -> Blocks.f_152548_);
        builder.put((Object)Redux.locate("gilded_skyroot_leaves"), ReduxBlocks.GILDED_OAK_LEAVES);
        builder.put((Object)Redux.locate("gilded_skyroot_sapling"), ReduxBlocks.GILDED_OAK_SAPLING);
        builder.put((Object)Redux.locate("potted_gilded_skyroot_sapling"), ReduxBlocks.POTTED_GILDED_OAK_SAPLING);
        return builder.build();
    }

    private static Map<ResourceLocation, ResourceKey<Biome>> createBiomeMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Redux.locate("arctic_pines"), ReduxBiomes.FROSTED_FORESTS);
        builder.put((Object)Redux.locate("frosted_forest"), ReduxBiomes.FROSTED_FORESTS);
        builder.put((Object)Redux.locate("gilded_thicket"), ReduxBiomes.GILDED_GRASSLANDS);
        builder.put((Object)Redux.locate("highfields"), ReduxBiomes.SKYFIELDS);
        builder.put((Object)Redux.locate("highfields_forest"), ReduxBiomes.SKYFIELDS);
        builder.put((Object)Redux.locate("cloudcap_jungle"), ReduxBiomes.CLOUDCAPS);
        return builder.build();
    }

    private static Map<ResourceLocation, Supplier<? extends EntityType<?>>> createEntityMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        WOOD_TYPES.forEach((s, w) -> MappingsHooks.woodEntities(s, w, (ImmutableMap.Builder<ResourceLocation, Supplier<? extends EntityType<? extends Entity>>>)builder));
        builder.put((Object)Redux.locate("spectral_dart"), ReduxEntityTypes.VERIDIUM_DART);
        return builder.build();
    }

    public static <T> void remap(String unmapped, Supplier<? extends T> newValue, MissingMappingsEvent.Mapping<T> map) {
        MappingsHooks.remap(Redux.locate(unmapped), newValue.get(), map);
    }

    public static void item(String unmapped, Supplier<? extends ItemLike> newValue, MissingMappingsEvent.Mapping<Item> map) {
        MappingsHooks.remap(Redux.locate(unmapped), newValue.get().m_5456_(), map);
    }

    public static void block(String unmapped, Supplier<? extends Block> newValue, MissingMappingsEvent.Mapping<Block> map) {
        MappingsHooks.remap(Redux.locate(unmapped), newValue.get(), map);
    }

    public static <T> void remap(String unmapped, T newValue, MissingMappingsEvent.Mapping<T> map) {
        MappingsHooks.remap(Redux.locate(unmapped), newValue, map);
    }

    public static <T> void remap(ResourceLocation unmappedLoc, Supplier<? extends T> newValue, MissingMappingsEvent.Mapping<T> map) {
        MappingsHooks.remap(unmappedLoc, newValue.get(), map);
    }

    public static <T> void remap(ResourceLocation unmappedLoc, T newValue, MissingMappingsEvent.Mapping<T> map) {
        if (map.getKey().equals((Object)unmappedLoc)) {
            map.remap(newValue);
        }
    }

    public static void woodItems(String oldId, WoodHandler newHandler, ImmutableMap.Builder<ResourceLocation, Supplier<? extends ItemLike>> map) {
        map.put((Object)Redux.locate(oldId + "_planks"), newHandler.planks);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.logSuffix), newHandler.log);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.woodSuffix), newHandler.wood);
        newHandler.strippedLog.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.logSuffix), reg));
        newHandler.strippedWood.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.woodSuffix), reg));
        map.put((Object)Redux.locate(oldId + "_stairs"), newHandler.stairs);
        map.put((Object)Redux.locate(oldId + "_fence"), newHandler.fence);
        map.put((Object)Redux.locate(oldId + "_fence_gate"), newHandler.fenceGate);
        map.put((Object)Redux.locate(oldId + "_door"), newHandler.door);
        map.put((Object)Redux.locate(oldId + "_trapdoor"), newHandler.trapdoor);
        map.put((Object)Redux.locate(oldId + "_pressure_plate"), newHandler.pressurePlate);
        map.put((Object)Redux.locate(oldId + "_button"), newHandler.button);
        map.put((Object)Redux.locate(oldId + "_bookshelf"), newHandler.bookshelf);
        map.put((Object)Redux.locate(oldId + "_sign"), newHandler.signItem);
        map.put((Object)Redux.locate(oldId + "_boat"), newHandler.boatItem);
        map.put((Object)Redux.locate(oldId + "_chest_boat"), newHandler.chestBoatItem);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.logSuffix + "_wall"), newHandler.logWall);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.woodSuffix + "_wall"), newHandler.woodWall);
        newHandler.strippedLogWall.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.logSuffix + "_wall"), reg));
        newHandler.strippedWoodWall.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.woodSuffix + "_wall"), reg));
    }

    public static void woodBlocks(String oldId, WoodHandler newHandler, ImmutableMap.Builder<ResourceLocation, Supplier<? extends Block>> map) {
        map.put((Object)Redux.locate(oldId + "_planks"), newHandler.planks);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.logSuffix), newHandler.log);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.woodSuffix), newHandler.wood);
        newHandler.strippedLog.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.logSuffix), reg));
        newHandler.strippedWood.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.woodSuffix), reg));
        map.put((Object)Redux.locate(oldId + "_stairs"), newHandler.stairs);
        map.put((Object)Redux.locate(oldId + "_fence"), newHandler.fence);
        map.put((Object)Redux.locate(oldId + "_fence_gate"), newHandler.fenceGate);
        map.put((Object)Redux.locate(oldId + "_door"), newHandler.door);
        map.put((Object)Redux.locate(oldId + "_trapdoor"), newHandler.trapdoor);
        map.put((Object)Redux.locate(oldId + "_pressure_plate"), newHandler.pressurePlate);
        map.put((Object)Redux.locate(oldId + "_button"), newHandler.button);
        map.put((Object)Redux.locate(oldId + "_bookshelf"), newHandler.bookshelf);
        map.put((Object)Redux.locate(oldId + "_sign"), newHandler.sign);
        map.put((Object)Redux.locate(oldId + "_wall_sign"), newHandler.wallSign);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.logSuffix + "_wall"), newHandler.logWall);
        map.put((Object)Redux.locate(oldId + "_" + newHandler.woodSuffix + "_wall"), newHandler.woodWall);
        newHandler.strippedLogWall.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.logSuffix + "_wall"), reg));
        newHandler.strippedWoodWall.ifPresent(reg -> map.put((Object)Redux.locate("stripped_" + oldId + "_" + newHandler.woodSuffix + "_wall"), reg));
    }

    public static void woodEntities(String oldId, WoodHandler newHandler, ImmutableMap.Builder<ResourceLocation, Supplier<? extends EntityType<? extends Entity>>> map) {
        map.put((Object)Redux.locate(oldId + "_boat"), newHandler.boatEntity);
        map.put((Object)Redux.locate(oldId + "_chest_boat"), newHandler.chestBoatEntity);
    }
}

