/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.layer.entity;

import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.protect_your_moa.capability.armor.MoaArmor;
import com.aetherteam.protect_your_moa.item.combat.DyeableMoaArmorItem;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.zepalesque.redux.capability.animation.moa.MoaAnimation;
import net.zepalesque.redux.client.render.ReduxModelLayers;
import net.zepalesque.redux.client.render.entity.layer.entity.MoaReduxLayer;
import net.zepalesque.redux.client.render.entity.model.entity.MoaReduxModel;
import net.zepalesque.redux.client.render.util.MoaUtils;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.MoaModelType;
import net.zepalesque.redux.util.math.MathUtil;

public class MoaReduxArmorLayer
extends RenderLayer<Moa, MoaModel> {
    private final MoaReduxModel newArmor;
    private final MoaReduxModel oldArmor;
    private final MoaReduxLayer layerParent;

    public MoaReduxArmorLayer(RenderLayerParent<Moa, MoaModel> renderer, MoaReduxLayer layerParent, EntityModelSet modelSet) {
        super(renderer);
        this.newArmor = new MoaReduxModel(modelSet.m_171103_(ReduxModelLayers.MOA_ARMOR_NEW));
        this.oldArmor = new MoaReduxModel(modelSet.m_171103_(ReduxModelLayers.MOA_ARMOR_OLD));
        this.layerParent = layerParent;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Moa moa, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (MoaUtils.useNewModel(moa)) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.5, 0.0);
            MoaArmor.get((Moa)moa).ifPresent(moaArmor -> {
                Item item;
                ItemStack itemStack = moaArmor.getArmor();
                if (itemStack != null && !itemStack.m_41619_() && (item = itemStack.m_41720_()) instanceof MoaArmorItem) {
                    MoaArmorItem moaArmorItem = (MoaArmorItem)item;
                    MoaReduxModel model = this.setupAnimAndModel(moa, limbSwing, limbSwingAmount, partialTick);
                    model.m_6839_((Entity)moa, limbSwing, limbSwingAmount, partialTick);
                    model.setupAnim(moa, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    float f = 1.0f;
                    float f1 = 1.0f;
                    float f2 = 1.0f;
                    if (item instanceof DyeableMoaArmorItem) {
                        DyeableMoaArmorItem dyeable = (DyeableMoaArmorItem)item;
                        int i = dyeable.m_41121_(moaArmor.getArmor());
                        f = (float)(i >> 16 & 0xFF) / 255.0f;
                        f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        f2 = (float)(i & 0xFF) / 255.0f;
                        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)dyeable.getOverlayTexture()));
                        model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    VertexConsumer vertexconsumerx = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)moaArmorItem.getTexture()));
                    model.m_7695_(poseStack, vertexconsumerx, packedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f);
                }
            });
            poseStack.m_85849_();
        }
    }

    private MoaReduxModel setupAnimAndModel(Moa moa, float limbSwing, float limbSwingAmount, float partialTicks) {
        boolean useOriginalLegs = ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.refreshed;
        MoaReduxModel model = useOriginalLegs ? this.newArmor : this.oldArmor;
        model.neck.f_104204_ = ((MoaModel)this.m_117386_()).head.f_104204_ * 0.333f;
        model.neck.f_104203_ = ((MoaModel)this.m_117386_()).head.f_104203_ * 0.125f;
        model.head_part.f_104204_ = ((MoaModel)this.m_117386_()).head.f_104204_ * 0.667f;
        model.head_part.f_104203_ = ((MoaModel)this.m_117386_()).head.f_104203_ * 0.875f;
        model.jaw.f_104203_ = ((MoaModel)this.m_117386_()).jaw.f_104203_;
        float breathe = MathUtil.breathe((Entity)moa, partialTicks);
        if (moa.f_20916_ > 0 && (float)moa.f_20916_ - partialTicks > 0.0f) {
            int hit = moa.f_20917_ - moa.f_20916_;
            float hitSmooth = (float)hit + partialTicks;
            float baseRot = hitSmooth >= (float)moa.f_20917_ * 0.25f + 0.0f ? -Mth.m_14089_((float)(0.41887906f * (hitSmooth + 5.0f))) + 1.0f : -Mth.m_14089_((float)(1.2566371f * hitSmooth));
            float rot = baseRot * 0.3926991f;
            model.neck_hurtanim.f_104203_ = 0.6667f * rot;
            model.body_additions.f_104203_ = 0.3333f * rot + breathe;
            model.head_hurtanim.f_104203_ = -rot;
        } else {
            model.neck_hurtanim.f_104203_ = breathe * 0.5f;
            model.head_hurtanim.f_104203_ = -1.5f * breathe;
            model.neck_hurtanim.f_104204_ = 0.0f;
            model.head_hurtanim.f_104204_ = 0.0f;
            model.body_additions.f_104203_ = breathe;
        }
        model.middle_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.0f);
        model.left_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.6667f);
        model.right_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.3333f);
        model.wing_1.f_104203_ = ((MoaModel)this.m_117386_()).rightWing.f_104203_ * 0.625f + 1.5707964f - 0.2617889f;
        model.z_rot_wing_1.f_104205_ = ((MoaModel)this.m_117386_()).rightWing.f_104204_ * 0.875f + 0.2617889f - breathe;
        model.wing_2.f_104203_ = ((MoaModel)this.m_117386_()).leftWing.f_104203_ * 0.625f + 1.5707964f - 0.2617889f;
        model.z_rot_wing_2.f_104205_ = ((MoaModel)this.m_117386_()).leftWing.f_104204_ * 0.875f - 0.2617889f + breathe;
        model.feathers_3_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : -0.7853982f) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.0f);
        model.feathers_2_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : -0.5235988f) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.3333f);
        model.feathers_1_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : -0.43633232f) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.6667f);
        model.feathers_3_wing2.f_104203_ = model.feathers_3_wing1.f_104203_;
        model.feathers_2_wing2.f_104203_ = model.feathers_2_wing1.f_104203_;
        model.feathers_1_wing2.f_104203_ = model.feathers_1_wing1.f_104203_;
        float progress = moa.isEntityOnGround() ? 0.0f : 1.0f;
        float swingCalc = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (MoaAnimation.get(moa).isPresent()) {
            MoaAnimation moaAnimation = (MoaAnimation)MoaAnimation.get(moa).orElseThrow(() -> new IllegalStateException("Could not find MoaAnimation capability!"));
            progress = Mth.m_14179_((float)partialTicks, (float)moaAnimation.getPrevLegAnim(), (float)moaAnimation.getLegAnim()) * 0.2f;
        }
        if ((!moa.isSitting() || !moa.isEntityOnGround() && moa.isSitting()) && !useOriginalLegs) {
            model.leg1.f_233556_ = false;
            model.leg2.f_233556_ = false;
            model.leg1.f_104203_ = MathUtil.costrp(progress, -swingCalc * 0.8f, 0.2617994f);
            model.leg2.f_104203_ = MathUtil.costrp(progress, swingCalc * 0.8f, 0.2617994f);
            model.lower_leg1.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos(limbSwing * 0.6662f), swingCalc) * 0.3333f * limbSwingAmount, 0.43633232f);
            model.lower_leg2.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos((float)((double)(limbSwing * 0.6662f) + Math.PI)), -swingCalc) * 0.333f * limbSwingAmount, 0.43633232f);
            model.toes_stepanim_leg1.f_104203_ = MathUtil.costrp(progress, -model.lower_leg1.f_104203_ * 0.3333f, 0.0f);
            model.toes_stepanim_leg2.f_104203_ = MathUtil.costrp(progress, -model.lower_leg2.f_104203_ * 0.3333f, 0.0f);
            model.toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, 0.17453292f);
            model.toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, 0.17453292f);
            model.back_toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, -1.3089969f);
            model.back_toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, -1.3089969f);
        } else {
            model.leg1.f_233556_ = true;
            model.leg2.f_233556_ = true;
            ((MoaModel)this.m_117386_()).rightLeg.f_104203_ = MathUtil.costrp(progress, swingCalc, 0.6f);
            ((MoaModel)this.m_117386_()).leftLeg.f_104203_ = MathUtil.costrp(progress, -swingCalc, 0.6f);
        }
        return model;
    }
}

