/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.screen.config;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.packconfig.Category;
import net.zepalesque.redux.api.packconfig.IConfigSaving;
import net.zepalesque.redux.api.packconfig.PackConfig;
import net.zepalesque.redux.client.gui.backported.GuiGraphicsHelper;
import net.zepalesque.redux.client.gui.component.DynamicButton;
import net.zepalesque.redux.client.gui.component.DynamicImageButton;
import net.zepalesque.redux.client.gui.component.DynamicRenderableString;
import net.zepalesque.redux.client.gui.component.RenderableString;
import net.zepalesque.redux.client.gui.component.config.ISaveable;
import net.zepalesque.redux.client.gui.component.config.PageDependentString;
import net.zepalesque.redux.util.math.MathUtil;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class PackConfigMenu
extends Screen {
    private final Map<Integer, List<IConfigSaving>> pages = new HashMap<Integer, List<IConfigSaving>>();
    private final Map<Category, PackConfigMenu> cachedMenus = new HashMap<Category, PackConfigMenu>();
    public static final ResourceLocation LIGHT_DIRT_BACKGROUND = new ResourceLocation("textures/gui/light_dirt_background.png");
    public static final ResourceLocation PARENT_BUTTON_LOC = Redux.locate("textures/gui/config_menu/parent.png");
    public static final ResourceLocation BACK_BUTTON_LOC = Redux.locate("textures/gui/config_menu/back.png");
    public static final ResourceLocation NEXT_BUTTON_LOC = Redux.locate("textures/gui/config_menu/next.png");
    public static final ResourceLocation MENU_LOC = Redux.locate("textures/gui/config_menu/config_menu.png");
    public static final ResourceLocation LIST_LOC = Redux.locate("textures/gui/config_menu/config_bars.png");
    @Nullable
    private final PackConfigMenu parentScreen;
    private final Category category;
    private final Category top;
    private List<Category> categories;
    private List<PackConfig<?>> configs;
    private int currentPageNumber;
    private boolean valChanged = false;
    private boolean goingUp = false;
    @Nullable
    private PackSelectionScreen selSc = null;
    private final Collection<ISaveable> saveables = new ArrayList<ISaveable>();

    public PackConfigMenu(Component title, Category base, @Nullable PackConfigMenu parent) {
        super(title);
        this.category = base;
        this.top = base.getRoot();
        this.parentScreen = parent;
    }

    public void setSelectionScreen(PackSelectionScreen screen) {
        this.selSc = screen;
    }

    public void markChanged(boolean shouldMark) {
        if (shouldMark) {
            if (this.parentScreen != null) {
                this.parentScreen.markChanged(true);
                this.markChildren(true);
            } else {
                this.valChanged = true;
            }
        }
    }

    public void markChildren(boolean shouldMark) {
        if (shouldMark) {
            this.cachedMenus.forEach((category1, menu) -> menu.markChildren(true));
        }
    }

    public boolean isMarked() {
        return this.valChanged;
    }

    public void m_6305_(PoseStack guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        this.renderMenu(guiGraphics);
        this.renderList(guiGraphics);
        super.m_6305_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void goInto(Category cat, Minecraft mc) {
        PackConfigMenu menu;
        this.saveAll();
        if (this.cachedMenus.containsKey(cat)) {
            menu = this.cachedMenus.get(cat);
        } else {
            menu = new PackConfigMenu(this.f_96539_, cat, this);
            if (this.valChanged) {
                // empty if block
            }
            menu.valChanged = true;
            this.cachedMenus.put(cat, menu);
        }
        mc.m_91152_((Screen)menu);
    }

    public int getCurrentPage() {
        return this.currentPageNumber;
    }

    private void renderMenu(PoseStack guiGraphics) {
        GuiGraphicsHelper.blitNineSliced(MENU_LOC, guiGraphics, this.centerXStart(this.frameWidth()), this.centerYStart(this.frameHeight()), this.frameWidth(), this.frameHeight(), 30, 41, 30, 31, 192, 192, 0, 0);
    }

    private void renderList(PoseStack guiGraphics) {
        int width = this.frameWidth() - 28;
        int height = this.frameHeight() - 72;
        RenderSystem.m_157456_((int)0, (ResourceLocation)LIST_LOC);
        guiGraphics.m_85836_();
        PackConfigMenu.m_93160_((PoseStack)guiGraphics, (int)(this.centerXStart(this.frameWidth()) + 14), (int)(this.centerYStart(this.frameHeight()) + 41), (int)width, (int)height, (float)0.0f, (float)0.0f, (int)(width / 3), (int)(height / 3), (int)16, (int)16);
        guiGraphics.m_85849_();
    }

    private int centerXStart(int width) {
        return this.f_96543_ / 2 - width / 2;
    }

    private int centerYStart(int height) {
        return this.f_96544_ / 2 - height / 2;
    }

    private int centerXEnd(int width) {
        return this.f_96543_ / 2 + width / 2;
    }

    private int centerYEnd(int height) {
        return this.f_96544_ / 2 + height / 2;
    }

    private int frameWidth() {
        return MathUtil.toNearestEven((float)this.f_96543_ * 0.64f);
    }

    private int frameHeight() {
        int h = MathUtil.toNearestEven((float)this.f_96544_ * 0.9f);
        int diff = h % 24;
        return Math.max(h - diff, 96);
    }

    private int getMaxInList() {
        return Math.max(0, this.frameHeight() / 24 - 3);
    }

    protected void m_7856_() {
        this.pages.clear();
        super.m_7856_();
        int titleX = this.centerXStart(this.frameWidth()) + 32;
        int titleY = this.centerYStart(this.frameHeight()) + 21;
        int wide = this.frameWidth() - 64;
        this.m_169394_(new RenderableString((Component)Component.m_237110_((String)"gui.aether_redux.pack_config.file", (Object[])new Object[]{this.top.id()}), titleX, titleY, wide, 0xFFFFFF, this.f_96547_));
        MutableComponent mutableComponent = Component.m_237110_((String)(this.category.parent() == null ? "gui.aether_redux.pack_config.top" : "gui.aether_redux.pack_config.category"), (Object[])new Object[]{Component.m_237115_((String)("gui.aether_redux.pack_config.category." + this.category.id()))});
        Objects.requireNonNull(this.f_96547_);
        this.m_169394_(new RenderableString((Component)mutableComponent, titleX, titleY - 9, wide, 0xFFFFFF, this.f_96547_));
        ArrayList<Category> cats = new ArrayList<Category>();
        for (IConfigSaving iConfigSaving : this.category.members.values()) {
            if (!(iConfigSaving instanceof Category)) continue;
            Category cat = (Category)iConfigSaving;
            cats.add(cat);
        }
        this.categories = cats;
        ArrayList cfgs = new ArrayList();
        for (IConfigSaving iid : this.category.members.values()) {
            if (!(iid instanceof PackConfig)) continue;
            PackConfig config = (PackConfig)iid;
            cfgs.add(config);
        }
        this.configs = cfgs;
        this.createPages();
        for (Map.Entry<Integer, List<IConfigSaving>> entry : this.pages.entrySet()) {
            int baseXCat = this.centerXStart(this.frameWidth()) + 16;
            int baseXConfig = this.centerXEnd(this.frameWidth()) - 80;
            int baseY = this.centerYStart(this.frameHeight()) + 42;
            int pg = entry.getKey();
            List<IConfigSaving> list = entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                IConfigSaving id = list.get(i);
                if (id instanceof PackConfig) {
                    PackConfig config = (PackConfig)id;
                    AbstractWidget widget = config.mapper().createWidget(config, pg, this, Math.max(baseXConfig, baseXCat), baseY + i * 24, Math.min(64, this.frameWidth() - 32), 20, this.f_96547_);
                    this.m_142416_((GuiEventListener)widget);
                    if (widget instanceof ISaveable) {
                        ISaveable sav = (ISaveable)widget;
                        this.saveables.add(sav);
                    }
                    int width = this.frameWidth() - 98;
                    MutableComponent mutableComponent2 = Component.m_237115_((String)("gui.aether_redux.pack_config.config." + config.id()));
                    Objects.requireNonNull(this.f_96547_);
                    PageDependentString string = new PageDependentString((Component)mutableComponent2, this, baseXCat, baseY + i * 24 + (10 - 9 / 2), width, 0xFFFFFF, this.f_96547_, pg);
                    this.m_169394_(string);
                    continue;
                }
                if (!(id instanceof Category)) continue;
                Category cat = (Category)id;
                DynamicButton button2 = new DynamicButton(baseXCat, baseY + i * 24, this.frameWidth() - 32, 20, this, (Component)Component.m_237115_((String)("gui.aether_redux.pack_config.category." + cat.id())), b -> this.goInto(cat, this.f_96541_), pg, (Component)Component.m_237115_((String)("gui.aether_redux.pack_config.category_desc." + cat.id())));
                Supplier<Boolean> rightPage = () -> button2.getPage() == this.getCurrentPage();
                button2.setActiveSupplier(rightPage);
                button2.setVisibleSupplier(rightPage);
                this.m_142416_((GuiEventListener)button2);
            }
        }
        Supplier<Component> supplier = () -> {
            int page = this.currentPageNumber + 1;
            return Component.m_237110_((String)"gui.aether_redux.pack_config.page", (Object[])new Object[]{page + "/" + this.pages.size()});
        };
        Supplier<Integer> width = () -> Math.min(this.frameWidth() - 54, this.f_96547_.m_92852_((FormattedText)supplier.get()));
        int n = this.f_96543_ / 2;
        int n2 = this.centerYEnd(this.frameHeight()) - 16;
        Objects.requireNonNull(this.f_96547_);
        DynamicRenderableString pages = new DynamicRenderableString(supplier, n, n2 - 9 / 2, width, 0xFFFFFF, this.f_96547_);
        this.m_169394_(pages);
        DynamicImageButton next = new DynamicImageButton(this.centerXEnd(this.frameWidth()) - 26, this.centerYEnd(this.frameHeight()) - 26, 20, 20, 0, 0, 20, NEXT_BUTTON_LOC, 64, 64, button -> {
            if (this.hasNext()) {
                ++this.currentPageNumber;
            }
        }).setActiveSupplier(this::hasNext);
        this.m_142416_((GuiEventListener)next);
        DynamicImageButton prev = new DynamicImageButton(this.centerXStart(this.frameWidth()) + 6, this.centerYEnd(this.frameHeight()) - 26, 20, 20, 0, 0, 20, BACK_BUTTON_LOC, 64, 64, button -> {
            if (this.hasPrev()) {
                --this.currentPageNumber;
            }
        }).setActiveSupplier(this::hasPrev);
        this.m_142416_((GuiEventListener)prev);
        DynamicImageButton out = new DynamicImageButton(this.centerXStart(this.frameWidth()) + 6, this.centerYStart(this.frameHeight()) + 11, 20, 20, 0, 0, 20, BACK_BUTTON_LOC, 64, 64, button -> this.m_7379_());
        this.m_142416_((GuiEventListener)out);
        DynamicImageButton up = new DynamicImageButton(this.centerXEnd(this.frameWidth()) - 26, this.centerYStart(this.frameHeight()) + 11, 20, 20, 0, 0, 20, PARENT_BUTTON_LOC, 64, 64, button -> {
            if (this.parentScreen != null) {
                this.goingUp = true;
                this.m_7379_();
                this.goingUp = false;
            }
        }).setActiveSupplier(() -> this.category.parent() != null);
        this.m_142416_((GuiEventListener)up);
    }

    public void m_7379_() {
        double mX = this.f_96541_.f_91067_.m_91589_();
        double mY = this.f_96541_.f_91067_.m_91594_();
        this.saveAll();
        if (this.goingUp) {
            super.m_7379_();
            if (this.parentScreen != null) {
                this.parentScreen.currentPageNumber = 0;
                this.f_96541_.m_91152_((Screen)this.parentScreen);
                GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)mX, (double)mY);
            }
        } else {
            this.closeRecursive(mX, mY);
        }
    }

    public void closeRecursive(double mX, double mY) {
        super.m_7379_();
        if (this.parentScreen != null) {
            this.parentScreen.closeRecursive(mX, mY);
        } else {
            if (this.selSc != null) {
                this.f_96541_.m_91152_((Screen)this.selSc);
            }
            GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)mX, (double)mY);
        }
    }

    public void saveAll() {
        this.saveables.forEach(ISaveable::save);
    }

    private boolean hasNext() {
        return this.currentPageNumber < this.pages.size() - 1;
    }

    private boolean hasPrev() {
        return this.currentPageNumber > 0;
    }

    private void createPages() {
        ArrayList<IConfigSaving> all = new ArrayList<IConfigSaving>();
        all.addAll(this.categories);
        all.addAll(this.configs);
        int totalSize = all.size();
        if (totalSize < this.getMaxInList()) {
            this.pages.put(0, all);
        } else {
            List list = Lists.partition(all, (int)this.getMaxInList());
            for (int i = 0; i < list.size(); ++i) {
                this.pages.put(i, (List)list.get(i));
            }
        }
    }
}

