/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.component.config;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.zepalesque.redux.api.packconfig.PackConfig;
import net.zepalesque.redux.client.gui.component.config.IDisplayPage;
import net.zepalesque.redux.client.gui.component.config.ISaveable;
import net.zepalesque.redux.client.gui.screen.config.PackConfigMenu;

public class SaveableEnumButton<T extends Enum<T>>
extends Button
implements ISaveable,
IDisplayPage {
    public final PackConfig<T> config;
    public final int page;
    private T value;
    private final PackConfigMenu menu;
    private Component tooltip;

    public SaveableEnumButton(int x, int y, int width, int height, PackConfig<T> config, int page, PackConfigMenu menu) {
        super(x, y, width, height, CommonComponents.f_237098_, SaveableEnumButton::cycle);
        this.config = config;
        this.value = (Enum)config.get();
        this.page = page;
        this.menu = menu;
        if (config.hasComment()) {
            this.tooltip = Component.m_237115_((String)("gui.aether_redux.config_desc." + config.id()));
        }
    }

    public static void cycle(Button b) {
        if (b instanceof SaveableEnumButton) {
            SaveableEnumButton enumButton = (SaveableEnumButton)b;
            enumButton.cycle();
        }
    }

    public void cycle() {
        Enum[] values = (Enum[])this.value.getClass().getEnumConstants();
        int ordinal = (((Enum)this.value).ordinal() + 1) % values.length;
        this.setValue(values[ordinal]);
    }

    public void m_6305_(PoseStack guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.f_93624_ = this.menu.getCurrentPage() == this.page;
        this.f_93623_ = this.menu.getCurrentPage() == this.page;
        super.m_6305_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.m_198029_() && this.tooltip != null) {
            this.menu.m_169388_(guiGraphics, List.of(this.tooltip), Optional.empty(), mouseX, mouseY);
        }
    }

    public Component m_6035_() {
        return Component.m_237115_((String)("gui.aether_redux.pack_config.enums." + ((Enum)this.value).name()));
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void save() {
        this.menu.markChanged(this.config.set(this.getValue()));
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

