/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.audio;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherMenuUtil;
import com.aetherteam.aether.client.WorldDisplayHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.zepalesque.redux.client.audio.ReduxMusic;

public class ReduxMusicManager {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final MusicManager musicManager = Minecraft.m_91087_().m_91397_();
    @Nullable
    private static SoundInstance currentMusic;
    private static int nextSongDelay;

    public static void tick() {
        Music music = ReduxMusicManager.getSituationalMusic();
        Music musicOpposite = ReduxMusicManager.getSituationalOppositeDaytimeMusic();
        if (music != null && musicOpposite != null) {
            if (currentMusic != null) {
                if (!music.m_11631_().m_11660_().equals((Object)currentMusic.m_7904_()) && !musicOpposite.m_11631_().m_11660_().equals((Object)currentMusic.m_7904_()) && music.m_11642_()) {
                    minecraft.m_91106_().m_120399_(currentMusic);
                    nextSongDelay = Mth.m_216271_((RandomSource)random, (int)0, (int)(music.m_11636_() / 2));
                }
                if (!minecraft.m_91106_().m_120403_(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, Mth.m_216271_((RandomSource)random, (int)music.m_11636_(), (int)music.m_11639_()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.m_11639_());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                ReduxMusicManager.startPlaying(music);
            }
        } else {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.m_216271_((RandomSource)random, (int)((Integer)AetherConfig.CLIENT.music_backup_min_delay.get()), (int)((Integer)AetherConfig.CLIENT.music_backup_max_delay.get())));
            }
        }
    }

    public static void startPlaying(Music pSelector) {
        musicManager.m_120186_();
        currentMusic = SimpleSoundInstance.m_119745_((SoundEvent)pSelector.m_11631_());
        if (currentMusic.m_5891_() == null) {
            currentMusic.m_6775_(minecraft.m_91106_());
        }
        if (currentMusic.m_5891_() != null) {
            minecraft.m_91106_().m_120367_(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.m_91106_().m_120399_(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static SoundInstance getCurrentMusic() {
        return currentMusic;
    }

    public static boolean isAetherWorldPreviewEnabled() {
        return AetherMenuUtil.isAetherMenu() && ReduxMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_aether_world_preview_menu_music.get() == false;
    }

    public static boolean isVanillaWorldPreviewEnabled() {
        return AetherMenuUtil.isMinecraftMenu() && ReduxMusicManager.isWorldPreviewEnabled() && (Boolean)AetherConfig.CLIENT.disable_vanilla_world_preview_menu_music.get() == false;
    }

    public static boolean isWorldPreviewEnabled() {
        return ReduxMusicManager.minecraft.f_91074_ != null && WorldDisplayHelper.isActive();
    }

    public static boolean isCreative(Holder<Biome> holder, Player player) {
        return player.f_19853_.m_46472_() != Level.f_46430_ && player.f_19853_.m_46472_() != Level.f_46429_ && holder.m_203656_(AetherTags.Biomes.AETHER_MUSIC) && !musicManager.m_120187_(Musics.f_11650_) && (!player.m_5842_() || !holder.m_203656_(BiomeTags.f_215801_)) && player.m_150110_().f_35937_ && player.m_150110_().f_35936_;
    }

    public static Music getSituationalMusic() {
        if (!(ReduxMusicManager.minecraft.f_91080_ instanceof WinScreen || ReduxMusicManager.isVanillaWorldPreviewEnabled() || ReduxMusicManager.isAetherWorldPreviewEnabled() || ReduxMusicManager.minecraft.f_91074_ == null)) {
            boolean night;
            Holder holder = ReduxMusicManager.minecraft.f_91074_.f_19853_.m_204166_(ReduxMusicManager.minecraft.f_91074_.m_20183_());
            long time = ReduxMusicManager.minecraft.f_91074_.f_108545_.m_6106_().m_6792_() % 72000L;
            boolean bl = night = time >= 39000L && time < 69000L;
            if (night) {
                return ReduxMusic.getNightMusicForBiome((Holder<Biome>)holder);
            }
            if (ReduxMusicManager.isCreative((Holder<Biome>)holder, (Player)ReduxMusicManager.minecraft.f_91074_)) {
                return ((Biome)holder.m_203334_()).m_47566_().orElse(Musics.f_11651_);
            }
        }
        return null;
    }

    public static Music getSituationalOppositeDaytimeMusic() {
        if (!(ReduxMusicManager.minecraft.f_91080_ instanceof WinScreen || ReduxMusicManager.isVanillaWorldPreviewEnabled() || ReduxMusicManager.isAetherWorldPreviewEnabled() || ReduxMusicManager.minecraft.f_91074_ == null)) {
            boolean night;
            Holder holder = ReduxMusicManager.minecraft.f_91074_.f_19853_.m_204166_(ReduxMusicManager.minecraft.f_91074_.m_20183_());
            long time = ReduxMusicManager.minecraft.f_91074_.f_108545_.m_6106_().m_6792_() % 72000L;
            boolean bl = night = time >= 39000L && time < 69000L;
            if (!night) {
                return ReduxMusic.getNightMusicForBiome((Holder<Biome>)holder);
            }
            if (ReduxMusicManager.isCreative((Holder<Biome>)holder, (Player)ReduxMusicManager.minecraft.f_91074_)) {
                return ((Biome)holder.m_203334_()).m_47566_().orElse(Musics.f_11651_);
            }
        }
        return null;
    }

    static {
        nextSongDelay = 100;
    }
}

