/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraftforge.fml.ModList;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.api.condition.ConditionSerializers;

public class ModLoaded
implements AbstractCondition<ModLoaded> {
    public static final Codec<ModLoaded> CODEC = RecordCodecBuilder.create(condition -> condition.group((App)Codec.STRING.fieldOf("mod_id").forGetter(config -> config.modid)).apply((Applicative)condition, ModLoaded::new));
    protected final String modid;

    public ModLoaded(String modid) {
        this.modid = modid;
    }

    @Override
    public boolean isConditionMet() {
        return ModList.get().isLoaded(this.modid);
    }

    @Override
    public Codec<ModLoaded> codec() {
        return (Codec)ConditionSerializers.MOD_LOADED.get();
    }

    @Override
    public String text() {
        return "ModLoaded{modid='" + this.modid + "'}";
    }
}

