/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.condition;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.api.condition.AetherConfigCondition;
import net.zepalesque.redux.api.condition.And;
import net.zepalesque.redux.api.condition.ModLoaded;
import net.zepalesque.redux.api.condition.Not;
import net.zepalesque.redux.api.condition.Or;
import net.zepalesque.redux.api.condition.ReduxConfigCondition;

public class ConditionSerializers {
    public static final DeferredRegister<Codec<? extends AbstractCondition<?>>> CODECS = DeferredRegister.create(Redux.Keys.CONDITION_SERIALIZER, (String)"aether_redux");
    public static final Supplier<IForgeRegistry<Codec<? extends AbstractCondition<?>>>> CONDITION_SERIALIZER_REGISTRY = CODECS.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<Codec<ModLoaded>> MOD_LOADED = CODECS.register("mod_loaded", () -> ModLoaded.CODEC);
    public static final RegistryObject<Codec<ReduxConfigCondition>> REDUX_CONFIG = CODECS.register("redux_config", () -> ReduxConfigCondition.CODEC);
    public static final RegistryObject<Codec<AetherConfigCondition>> AETHER_CONFIG = CODECS.register("aether_config", () -> AetherConfigCondition.CODEC);
    public static final RegistryObject<Codec<Not<?>>> NOT = CODECS.register("not", () -> Not.CODEC);
    public static final RegistryObject<Codec<Or<?, ?>>> OR = CODECS.register("or", () -> Or.CODEC);
    public static final RegistryObject<Codec<And<?, ?>>> AND = CODECS.register("and", () -> And.CODEC);

    public static Codec<? extends AbstractCondition<?>> get(ResourceLocation resourceLocation) {
        return (Codec)CONDITION_SERIALIZER_REGISTRY.get().getValue(resourceLocation);
    }

    public static ResourceLocation getKey(Codec<? extends AbstractCondition<?>> condition) {
        return CONDITION_SERIALIZER_REGISTRY.get().getKey(condition);
    }
}

