/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.slottype;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.slottype.SlotType;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class SlotTypeManager {
    private static Map<String, SlotType.Builder> imcBuilders = new HashMap<String, SlotType.Builder>();
    private static Map<String, SlotType.Builder> configBuilders = new HashMap<String, SlotType.Builder>();
    private static Map<String, Set<String>> idsToMods = new HashMap<String, Set<String>>();

    public static Map<String, Set<String>> getIdsToMods() {
        return ImmutableMap.copyOf(idsToMods);
    }

    public static void buildImcSlotTypes(Stream<InterModComms.IMCMessage> register, Stream<InterModComms.IMCMessage> modify) {
        imcBuilders.clear();
        SlotTypeManager.processImc(register, true);
        SlotTypeManager.processImc(modify, false);
    }

    public static void buildConfigSlotTypes() {
        configBuilders.clear();
        List<CuriosConfig.CuriosSettings.CuriosSetting> settings = CuriosConfig.curios;
        if (settings == null) {
            return;
        }
        settings.forEach(setting -> {
            boolean force;
            String id = setting.identifier;
            if (id == null || id.isEmpty()) {
                Curios.LOGGER.error("Missing identifier in curios config, skipping...");
                return;
            }
            SlotType.Builder builder = imcBuilders.get(id);
            boolean bl = force = setting.override != null ? setting.override : false;
            if (builder == null) {
                builder = new SlotType.Builder(id);
                SlotTypeMessage.Builder preset = SlotTypePreset.findPreset(id).map(SlotTypePreset::getMessageBuilder).orElse(null);
                if (preset != null) {
                    SlotTypeMessage msg = preset.build();
                    builder.icon(msg.getIcon()).priority(msg.getPriority()).size(msg.getSize()).visible(msg.isVisible()).hasCosmetic(msg.hasCosmetic());
                }
            } else {
                builder = new SlotType.Builder(id).copyFrom(builder);
            }
            configBuilders.putIfAbsent(id, builder);
            idsToMods.computeIfAbsent(id, k -> new HashSet()).add("config");
            if (setting.priority != null) {
                builder.priority(setting.priority, force);
            }
            if (setting.icon != null && !setting.icon.isEmpty()) {
                builder.icon(new ResourceLocation(setting.icon));
            }
            if (setting.size != null) {
                builder.size(setting.size, force);
            }
            if (setting.visible != null) {
                builder.visible(setting.visible, force);
            }
            if (setting.hasCosmetic != null) {
                builder.hasCosmetic(setting.hasCosmetic, force);
            }
        });
        imcBuilders.forEach((key, builder) -> configBuilders.putIfAbsent((String)key, (SlotType.Builder)builder));
    }

    public static void buildSlotTypes() {
        Map<String, SlotType.Builder> builders = !configBuilders.isEmpty() ? configBuilders : imcBuilders;
        builders.values().forEach(builder -> CuriosApi.getSlotHelper().addSlotType(builder.build()));
        CurioArgumentType.slotIds = CuriosApi.getSlotHelper().getSlotTypeIds();
    }

    private static void processImc(Stream<InterModComms.IMCMessage> messages, boolean create) {
        TreeMap messageMap = new TreeMap();
        List<InterModComms.IMCMessage> messageList = messages.collect(Collectors.toList());
        messageList.forEach(msg -> {
            Object firstChild;
            Iterable iterable;
            Iterator iter;
            Object messageObject = msg.getMessageSupplier().get();
            if (messageObject instanceof SlotTypeMessage) {
                messageMap.computeIfAbsent(msg.getSenderModId(), k -> new ArrayList()).add((SlotTypeMessage)messageObject);
            } else if (messageObject instanceof Iterable && (iter = (iterable = (Iterable)messageObject).iterator()).hasNext() && (firstChild = iter.next()) instanceof SlotTypeMessage) {
                messageMap.computeIfAbsent(msg.getSenderModId(), k -> new ArrayList()).add((SlotTypeMessage)firstChild);
                iter.forEachRemaining(child -> messageMap.computeIfAbsent(msg.getSenderModId(), k -> new ArrayList()).add((SlotTypeMessage)child));
            }
        });
        for (Map.Entry entry : messageMap.entrySet()) {
            String modId = (String)entry.getKey();
            for (SlotTypeMessage msg2 : (List)entry.getValue()) {
                SlotTypeMessage presetMsg;
                String id = msg2.getIdentifier();
                SlotType.Builder builder = imcBuilders.get(id);
                if (builder == null && create) {
                    builder = new SlotType.Builder(id);
                    imcBuilders.put(id, builder);
                    idsToMods.computeIfAbsent(id, k -> new HashSet()).add(modId);
                }
                if (builder == null) continue;
                builder.size(msg2.getSize()).visible(msg2.isVisible()).hasCosmetic(msg2.hasCosmetic());
                SlotTypeMessage.Builder preset = SlotTypePreset.findPreset(id).map(SlotTypePreset::getMessageBuilder).orElse(null);
                SlotTypeMessage slotTypeMessage = presetMsg = preset != null ? preset.build() : null;
                if (msg2.getIcon() == null && presetMsg != null) {
                    builder.icon(presetMsg.getIcon());
                } else {
                    builder.icon(msg2.getIcon());
                }
                if (msg2.getPriority() == null && presetMsg != null) {
                    builder.priority(presetMsg.getPriority());
                    continue;
                }
                builder.priority(msg2.getPriority());
            }
        }
    }
}

