/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FurnitureRecipeJsonFactory
implements RecipeBuilder {
    private final Item output;
    private final int outputCount;
    private final List<Ingredient> inputs = Lists.newArrayList();
    private final Advancement.Builder builder = Advancement.Builder.m_138353_();
    @Nullable
    private Tag nbtElement;
    @Nullable
    private String group;

    public FurnitureRecipeJsonFactory(ItemLike output, int outputCount) {
        this.output = output.m_5456_();
        this.outputCount = outputCount;
    }

    public FurnitureRecipeJsonFactory(ItemLike output, int outputCount, @Nullable Tag nbtElement) {
        this.output = output.m_5456_();
        this.outputCount = outputCount;
        this.nbtElement = nbtElement;
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output, int count, Tag nbtElement) {
        return new FurnitureRecipeJsonFactory(output, count, nbtElement);
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output, Tag nbtElement) {
        return new FurnitureRecipeJsonFactory(output, 1, nbtElement);
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output) {
        return new FurnitureRecipeJsonFactory(output, 1);
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output, int count) {
        return new FurnitureRecipeJsonFactory(output, count);
    }

    public FurnitureRecipeJsonFactory input(TagKey<Item> tag) {
        return this.input(Ingredient.m_204132_(tag));
    }

    public FurnitureRecipeJsonFactory input(ItemLike itemProvider) {
        return this.input(itemProvider, 1);
    }

    public FurnitureRecipeJsonFactory input(ItemLike itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider}));
        }
        return this;
    }

    public FurnitureRecipeJsonFactory input(Ingredient ingredient) {
        return this.input(ingredient, 1);
    }

    public FurnitureRecipeJsonFactory input(Ingredient ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputs.add(ingredient);
        }
        return this;
    }

    public FurnitureRecipeJsonFactory criterion(String string, CriterionTriggerInstance criterionConditions) {
        this.builder.m_138386_(string, criterionConditions);
        return this;
    }

    public FurnitureRecipeJsonFactory group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public Item m_142372_() {
        return this.output;
    }

    public void m_126140_(Consumer<FinishedRecipe> exporter, ResourceLocation recipeId) {
        this.builder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        exporter.accept(new FurnitureRecipeJsonProvider(recipeId, this.output, this.nbtElement, this.outputCount, this.group == null ? "" : this.group, this.inputs, this.builder, new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.output.m_41471_().m_40783_() + "/" + recipeId.m_135815_())));
    }

    private void validate(ResourceLocation recipeId) {
        if (this.builder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static class FurnitureRecipeJsonProvider
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final Item output;
        private final int count;
        private final String group;
        private final List<Ingredient> inputs;
        private final Advancement.Builder builder;
        private final ResourceLocation advancementId;
        @Nullable
        private final Tag nbtElement;

        public FurnitureRecipeJsonProvider(ResourceLocation recipeId, Item output, @Nullable Tag nbtElement, int outputCount, String group, List<Ingredient> inputs, Advancement.Builder builder, ResourceLocation advancementId) {
            this.recipeId = recipeId;
            this.output = output;
            this.count = outputCount;
            this.group = group;
            this.inputs = inputs;
            this.builder = builder;
            this.advancementId = advancementId;
            this.nbtElement = nbtElement;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.inputs) {
                jsonArray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.output).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.nbtElement != null) {
                JsonElement object = (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, this.nbtElement);
                jsonObject.add("tag", object);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeTypes.FURNITURE_SERIALIZER;
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

