/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic.forge;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.registry.dynamic.forge.LateBlockRegistryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

public class LateBlockRegistryForge {
    private static boolean hasRegisteredBlockSets = false;
    private static Pair<List<Runnable>, List<Consumer<IForgeRegistry<Item>>>> LATE_REGISTRATION_QUEUE = null;

    public static void addDynamicBlockRegistration() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (LATE_REGISTRATION_QUEUE == null) {
            LATE_REGISTRATION_QUEUE = Pair.of(new ArrayList(), new ArrayList());
            bus.addListener(EventPriority.HIGHEST, LateBlockRegistryForge::registerLateBlockAndItems);
        }
        Consumer<RegisterEvent> eventConsumer = registerEvent -> {
            if (registerEvent.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                Runnable blockEvent = () -> {
                    IForgeRegistry registry = registerEvent.getForgeRegistry();
                    if (registry instanceof ForgeRegistry) {
                        ForgeRegistry fr = (ForgeRegistry)registry;
                        boolean frozen = fr.isLocked();
                        fr.unfreeze();
                        LateBlockRegistryImpl.registerBlocks((IForgeRegistry<Block>)registry);
                        if (frozen) {
                            fr.freeze();
                        }
                    }
                };
                ((List)LATE_REGISTRATION_QUEUE.getFirst()).add(blockEvent);
            }
        };
        Consumer<IForgeRegistry> itemEvent = LateBlockRegistryImpl::registerItems;
        ((List)LATE_REGISTRATION_QUEUE.getSecond()).add(itemEvent);
        bus.addListener(EventPriority.HIGHEST, eventConsumer);
    }

    public static void registerLateBlockAndItems(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            return;
        }
        if (!hasRegisteredBlockSets) {
            DynamicBlockRegistry.initialize();
            hasRegisteredBlockSets = true;
        }
        IForgeRegistry forgeRegistry = event.getForgeRegistry();
        ((List)LATE_REGISTRATION_QUEUE.getFirst()).forEach(Runnable::run);
        ((List)LATE_REGISTRATION_QUEUE.getSecond()).forEach(registerConsumer -> registerConsumer.accept(forgeRegistry));
        ((List)LATE_REGISTRATION_QUEUE.getFirst()).clear();
        ((List)LATE_REGISTRATION_QUEUE.getSecond()).clear();
    }
}

