/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LightSwitchItem
extends BlockItem {
    private Block block;

    public LightSwitchItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.block = block;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (player.m_6144_()) {
            stack.m_41751_(null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof PowerableBlock) {
            if (block instanceof PendantBlock) {
                boolean isRoot;
                boolean isSingle = (Boolean)state.m_61143_((Property)PendantBlock.DOWN) == false && (Boolean)state.m_61143_((Property)PendantBlock.UP) == false;
                boolean bl = isRoot = (Boolean)state.m_61143_((Property)PendantBlock.DOWN) != false && (Boolean)state.m_61143_((Property)PendantBlock.UP) == false;
                if (isSingle || isRoot) {
                    this.addLight(context.m_43722_(), pos);
                } else if (context.m_43725_().f_46443_) {
                    context.m_43723_().m_5661_((Component)Component.m_237115_((String)"message.pfm.light_switch_not_canopy"), false);
                }
            } else {
                this.addLight(context.m_43722_(), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Direction side = context.m_43719_();
        ListTag lights = LightSwitchItem.getLights(context.m_43722_());
        if (!side.m_122434_().m_122479_()) {
            return false;
        }
        if (lights != null) {
            ArrayList<BlockPos> removedLights = new ArrayList<BlockPos>();
            ArrayList<BlockPos> lightOffsets = new ArrayList<BlockPos>();
            Iterator iterator = lights.iterator();
            while (iterator.hasNext()) {
                Tag nbtElement = (Tag)iterator.next();
                BlockPos lightPos = BlockPos.m_122022_((long)((LongTag)nbtElement).m_7046_());
                double distance = Math.sqrt(lightPos.m_203202_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                if (distance > 16.0) {
                    removedLights.add(BlockPos.m_122022_((long)((LongTag)nbtElement).m_7046_()));
                    iterator.remove();
                    continue;
                }
                lightOffsets.add(pos.m_121996_((Vec3i)lightPos));
            }
            context.m_43722_().m_41751_(new CompoundTag());
            for (BlockPos blockPos : lightOffsets) {
                this.addLight(context.m_43722_(), blockPos);
            }
            if (!removedLights.isEmpty() && context.m_43725_().f_46443_) {
                context.m_43723_().m_5661_((Component)Component.m_237110_((String)"message.pfm.light_switch_far", (Object[])new Object[]{removedLights.toString()}), false);
            }
        }
        return state.m_60734_().m_7898_(state, (LevelReader)world, pos) && side.m_122434_().m_122479_();
    }

    private void addLight(ItemStack stack, BlockPos pos) {
        ListTag tagList;
        CompoundTag blockEntityTag;
        CompoundTag nbtCompound = LightSwitchItem.createTag(stack);
        if (!nbtCompound.m_128425_("BlockEntityTag", 10)) {
            nbtCompound.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if (!(blockEntityTag = nbtCompound.m_128469_("BlockEntityTag")).m_128425_("lights", 9)) {
            blockEntityTag.m_128365_("lights", (Tag)new ListTag());
        }
        if (!this.containsLight(tagList = (ListTag)blockEntityTag.m_128423_("lights"), pos)) {
            tagList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
    }

    private boolean containsLight(ListTag tagList, BlockPos pos) {
        for (int i = 0; i < tagList.size(); ++i) {
            LongTag tagLong = (LongTag)tagList.get(i);
            if (tagLong.m_7046_() != pos.m_121878_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ListTag getLights(ItemStack stack) {
        CompoundTag blockEntityTag;
        CompoundTag nbtCompound;
        if (stack.m_41782_() && (nbtCompound = stack.m_41783_()).m_128425_("BlockEntityTag", 10) && (blockEntityTag = nbtCompound.m_128469_("BlockEntityTag")).m_128425_("lights", 9)) {
            return (ListTag)blockEntityTag.m_128423_("lights");
        }
        return null;
    }

    private static CompoundTag createTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (stack.m_41782_() && LightSwitchItem.getLights(stack) != null) {
            int lightNum = LightSwitchItem.getLights(stack).size();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.pfm.light_switch_connected", (Object[])new Object[]{lightNum}));
        }
        super.m_7373_(stack, world, tooltip, context);
    }
}

