/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.jei;

import com.unlikepaladin.pfm.compat.jei.PaladinFurnitureModJEI;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FurnitureCategory
implements IRecipeCategory<FurnitureRecipe> {
    private final IDrawable BACKGROUND;
    public static final ResourceLocation TEXTURE_GUI_VANILLA = new ResourceLocation("pfm:textures/gui/gui_jei.png");
    public final IDrawable ICON;
    public static final Component TITLE = Component.m_237115_((String)"rei.pfm.furniture");
    private final ICraftingGridHelper craftingGridHelper;
    private static final int craftOutputSlot = 9;
    private static final int craftInputSlot1 = 0;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("pfm", "crafting");

    public FurnitureCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.WORKING_TABLE));
        this.BACKGROUND = guiHelper.createDrawable(TEXTURE_GUI_VANILLA, 0, 60, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public RecipeType<FurnitureRecipe> getRecipeType() {
        return PaladinFurnitureModJEI.FURNITURE_RECIPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FurnitureRecipe recipe, IFocusGroup focuses) {
        int width;
        NonNullList<Ingredient> ingredientsList = recipe.m_7527_();
        LinkedHashMap<Item, Integer> containedItems = new LinkedHashMap<Item, Integer>();
        for (Object ingredient : ingredientsList) {
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!containedItems.containsKey(stack.m_41720_())) {
                    containedItems.put(stack.m_41720_(), 1);
                    continue;
                }
                containedItems.put(stack.m_41720_(), (Integer)((HashMap)containedItems).get(stack.m_41720_()) + 1);
            }
        }
        ArrayList<Ingredient> finalList = new ArrayList<Ingredient>();
        for (Object entry : ((HashMap)containedItems).entrySet()) {
            finalList.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())}));
        }
        finalList.sort(Comparator.comparing(o -> o.m_43908_()[0].m_41720_().toString()));
        ArrayList<List<ItemStack>> inputLists = new ArrayList<List<ItemStack>>();
        for (Ingredient input : finalList) {
            ItemStack[] stacks = input.m_43908_();
            List<ItemStack> expandedInput = List.of(stacks);
            inputLists.add(expandedInput);
        }
        ItemStack resultItem = recipe.m_8043_();
        int height = width = FurnitureCategory.getSize(inputLists.size());
        this.craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(resultItem));
        this.craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputLists, width, height);
    }

    private static int getSize(int total) {
        if (total > 4) {
            return 3;
        }
        if (total > 1) {
            return 2;
        }
        return 1;
    }
}

