/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.fridge;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.fridge.forge.UnbakedFridgeModelImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedFridgeModel
implements UnbakedModel {
    public static final List<String> FRIDGE_MODEL_PARTS_BASE = new ArrayList<String>(){
        {
            this.add("block/fridge/fridge_single");
            this.add("block/fridge/fridge_top");
            this.add("block/fridge/fridge_middle");
            this.add("block/fridge/fridge_bottom");
            this.add("block/fridge/fridge");
            this.add("block/fridge/fridge_middle_freezer");
            this.add("block/fridge/fridge_single_open");
            this.add("block/fridge/fridge_top_open");
            this.add("block/fridge/fridge_middle_open");
            this.add("block/fridge/fridge_bottom_open");
            this.add("block/fridge/fridge_open");
            this.add("block/fridge/fridge_middle_freezer_open");
        }
    };
    public static final List<ResourceLocation> ALL_MODEL_IDS = new ArrayList<ResourceLocation>(){
        {
            for (String part : FRIDGE_MODEL_PARTS_BASE) {
                this.add(new ResourceLocation("pfm", part));
            }
            for (String part : FRIDGE_MODEL_PARTS_BASE) {
                this.add(new ResourceLocation("pfm", part.replaceAll("fridge", "gray_fridge")));
            }
        }
    };
    private static final ResourceLocation PARENT = new ResourceLocation("block/block");
    private final Material frameTex;
    public static final List<ResourceLocation> FRIDGE_MODEL_IDS = new ArrayList<ResourceLocation>(){
        {
            this.add(new ResourceLocation("pfm", "block/white_fridge"));
            this.add(new ResourceLocation("pfm", "block/gray_fridge"));
        }
    };
    private final ResourceLocation id;

    public Collection<ResourceLocation> m_7970_() {
        return List.of(PARENT);
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        return List.of(this.frameTex);
    }

    public UnbakedFridgeModel(ResourceLocation id) {
        this.id = id;
        this.frameTex = new Material(TextureAtlas.f_118259_, ModelHelper.getVanillaConcreteColor(this.id));
    }

    @Nullable
    public BakedModel m_7611_(ModelBakery loader, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer, ResourceLocation modelId) {
        LinkedHashMap<String, BakedModel> bakedModels = new LinkedHashMap<String, BakedModel>();
        for (String modelPart : FRIDGE_MODEL_PARTS_BASE) {
            if (modelId.m_135815_().contains("gray")) {
                modelPart = modelPart.replaceAll("fridge", "gray_fridge");
            }
            bakedModels.put(modelPart, loader.m_119349_(new ResourceLocation("pfm", modelPart), rotationContainer));
        }
        return UnbakedFridgeModel.getBakedModel(textureGetter.apply(this.frameTex), rotationContainer, bakedModels, bakedModels.keySet().stream().toList());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getBakedModel(TextureAtlasSprite frame, ModelState settings, Map<String, BakedModel> bakedModels, List<String> MODEL_PARTS) {
        void var3_3;
        void var2_2;
        void var1_1;
        return UnbakedFridgeModelImpl.getBakedModel(frame, (ModelState)var1_1, (Map<String, BakedModel>)var2_2, (List<String>)var3_3);
    }
}

