/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.KitchenStovetopBlock;
import com.unlikepaladin.pfm.blocks.blockentities.forge.StovetopBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StovetopBlockEntity
extends BlockEntity
implements Clearable {
    public final NonNullList<ItemStack> itemsBeingCooked = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public StovetopBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.STOVE_TOP_BLOCK_ENTITY, pos, state);
    }

    public static void litServerTick(Level world, BlockPos pos, BlockState state, StovetopBlockEntity stovetopBlockEntity) {
        boolean bl = false;
        for (int i = 0; i < stovetopBlockEntity.itemsBeingCooked.size(); ++i) {
            ItemStack itemStack = (ItemStack)stovetopBlockEntity.itemsBeingCooked.get(i);
            if (itemStack.m_41619_()) continue;
            bl = true;
            int n = i;
            if (stovetopBlockEntity.cookingTimes[n] < 600) {
                stovetopBlockEntity.cookingTimes[n] = stovetopBlockEntity.cookingTimes[n] + 2;
            }
            if (stovetopBlockEntity.cookingTimes[i] < stovetopBlockEntity.cookingTotalTimes[i]) continue;
            SimpleContainer inventory = new SimpleContainer(new ItemStack[]{itemStack});
            ItemStack itemStack2 = world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)inventory, world).map(campfireCookingRecipe -> campfireCookingRecipe.m_5874_((Container)inventory)).orElse(itemStack);
            if (PaladinFurnitureMod.getPFMConfig().doesFoodPopOffStove()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack2);
                stovetopBlockEntity.itemsBeingCooked.set(i, (Object)ItemStack.f_41583_);
            } else {
                stovetopBlockEntity.itemsBeingCooked.set(i, (Object)itemStack2);
            }
            world.m_7260_(pos, state, state, 3);
        }
        if (bl) {
            CampfireBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void unlitServerTick(Level world, BlockPos pos, BlockState state, StovetopBlockEntity stovetopBlockEntity) {
        boolean bl = false;
        for (int i = 0; i < stovetopBlockEntity.itemsBeingCooked.size(); ++i) {
            if (stovetopBlockEntity.cookingTimes[i] <= 0) continue;
            bl = true;
            stovetopBlockEntity.cookingTimes[i] = Mth.m_14045_((int)(stovetopBlockEntity.cookingTimes[i] - 2), (int)0, (int)stovetopBlockEntity.cookingTotalTimes[i]);
        }
        if (bl) {
            CampfireBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, StovetopBlockEntity stovetopBlockEntity) {
        RandomSource random = world.f_46441_;
        int i = ((Direction)state.m_61143_((Property)KitchenStovetopBlock.FACING)).m_122427_().m_122416_();
        for (int j = 0; j < stovetopBlockEntity.itemsBeingCooked.size(); ++j) {
            ItemStack stack = (ItemStack)stovetopBlockEntity.itemsBeingCooked.get(j);
            if (stack.m_41619_() || !(random.m_188501_() < 0.2f) || world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), world).isEmpty()) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + i, 4));
            float f = 0.2125f;
            double x = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * f + (float)direction.m_122427_().m_122429_() * f);
            double y = (double)pos.m_123342_() + 0.2;
            double z = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * f + (float)direction.m_122427_().m_122431_() * f);
            for (int k = 0; k < 4; ++k) {
                if (random.m_188501_() < 0.9f) continue;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    public Container getInventory() {
        SimpleContainer inventory = new SimpleContainer(this.itemsBeingCooked.size());
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)this.itemsBeingCooked.get(i));
        }
        return inventory;
    }

    public void m_142466_(CompoundTag nbt) {
        int[] is;
        super.m_142466_(nbt);
        this.itemsBeingCooked.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.itemsBeingCooked);
        if (nbt.m_128425_("CookingTimes", 11)) {
            is = nbt.m_128465_("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.m_128425_("CookingTotalTimes", 11)) {
            is = nbt.m_128465_("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        this.saveInitialChunkData(nbt);
        nbt.m_128385_("CookingTimes", this.cookingTimes);
        nbt.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
    }

    protected CompoundTag saveInitialChunkData(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18976_((CompoundTag)nbt, this.itemsBeingCooked, (boolean)true);
        return nbt;
    }

    public ItemStack removeStack(int slot) {
        ItemStack stack = ((ItemStack)this.itemsBeingCooked.get(slot)).m_41777_();
        this.itemsBeingCooked.set(slot, (Object)ItemStack.f_41583_);
        this.updateListeners();
        return stack;
    }

    public Optional<CampfireCookingRecipe> getRecipeFor(ItemStack item) {
        if (this.itemsBeingCooked.stream().noneMatch(ItemStack::m_41619_)) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{item}), this.f_58857_);
    }

    public boolean addItem(ItemStack item, int integer) {
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemsBeingCooked.get(i);
            if (!itemStack.m_41619_()) continue;
            this.cookingTotalTimes[i] = integer;
            this.cookingTimes[i] = 0;
            this.itemsBeingCooked.set(i, (Object)item.m_41620_(1));
            this.updateListeners();
            return true;
        }
        return false;
    }

    private void updateListeners() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.itemsBeingCooked.clear();
        this.updateListeners();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends StovetopBlockEntity> getFactory() {
        return StovetopBlockEntityImpl.getFactory();
    }
}

