/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.google.common.collect.Maps;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.forge.FreezerBlockEntityImpl;
import com.unlikepaladin.pfm.menus.FreezerScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            if (state.m_60734_() instanceof FreezerBlock) {
                FreezerBlockEntity.this.playSound(state, SoundEvents.f_12012_);
                FreezerBlockEntity.this.setOpen(state, true);
            }
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            if (state.m_60734_() instanceof FreezerBlock) {
                FreezerBlockEntity.this.playSound(state, SoundEvents.f_12011_);
                FreezerBlockEntity.this.setOpen(state, false);
            }
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof FreezerScreenHandler) {
                Container inventory = ((FreezerScreenHandler)player.f_36096_).getInventory();
                return inventory == FreezerBlockEntity.this;
            }
            return false;
        }
    };
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 1};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    int fuelTime;
    int fuelTimeTotal;
    int freezeTime;
    int freezeTimeTotal;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FreezerBlockEntity.this.fuelTime;
                }
                case 1: {
                    return FreezerBlockEntity.this.fuelTimeTotal;
                }
                case 2: {
                    return FreezerBlockEntity.this.freezeTime;
                }
                case 3: {
                    return FreezerBlockEntity.this.freezeTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.freezeTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeTypes.FREEZING_RECIPE;

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.FREEZER_BLOCK_ENTITY, pos, state);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public static Map<Item, Integer> createFuelTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_42452_, 50);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_41979_, 62);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_41981_, 400);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_41980_, 1600);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_42201_, 14400);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.f_42363_, 129600);
        return map;
    }

    private boolean isActive() {
        return this.fuelTime > 0;
    }

    private static void addFuel(Map<Item, Integer> fuelTimes, TagKey<Item> tag, int fuelTime) {
        for (Holder registryEntry : Registry.f_122827_.m_206058_(tag)) {
            fuelTimes.put((Item)registryEntry.m_203334_(), fuelTime);
        }
    }

    private static void addFuel(Map<Item, Integer> fuelTimes, ItemLike item, int fuelTime) {
        Item item2 = item.m_5456_();
        fuelTimes.put(item2, fuelTime);
    }

    private static int getFreezeTime(Level world, RecipeType<? extends AbstractCookingRecipe> recipeType, Container inventory) {
        return world.m_7465_().m_44015_(recipeType, inventory, world).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    public static boolean canUseAsFuel(ItemStack stack) {
        return FreezerBlockEntity.createFuelTimeMap().containsKey(stack.m_41720_());
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1) {
            ItemStack itemStack = (ItemStack)this.inventory.get(1);
            return FreezerBlockEntity.canUseAsFuel(stack);
        }
        return true;
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack itemStack : this.inventory) {
            finder.m_36491_(itemStack);
        }
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        if (dir == Direction.DOWN && slot == 1) {
            return stack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean bl = !stack.m_41619_() && stack.m_41656_(itemStack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !bl) {
            this.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(this.f_58857_, this.recipeType, (Container)this);
            this.freezeTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation identifier = recipe.m_6423_();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public int m_6643_() {
        return 3;
    }

    protected int getFuelTime(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        Item item = fuel.m_41720_();
        return FreezerBlockEntity.createFuelTimeMap().getOrDefault(item, 0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fuelTime = nbt.m_128448_("FuelTimeLeft");
        this.freezeTime = nbt.m_128448_("FreezeTime");
        this.freezeTimeTotal = nbt.m_128448_("FreezeTimeTotal");
        this.fuelTimeTotal = this.getFuelTime((ItemStack)this.inventory.get(1));
        CompoundTag nbtCompound = nbt.m_128469_("RecipesUsed");
        for (String string : nbtCompound.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(string), nbtCompound.m_128451_(string));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128376_("FuelTimeLeft", (short)this.fuelTime);
        nbt.m_128376_("FreezeTime", (short)this.freezeTime);
        nbt.m_128376_("FreezeTimeTotal", (short)this.freezeTimeTotal);
        CompoundTag nbtCompound = new CompoundTag();
        this.recipesUsed.forEach((identifier, integer) -> nbtCompound.m_128405_(identifier.toString(), integer.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)nbtCompound);
    }

    void setOpen(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 10);
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)FreezerBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.pfm.freezer");
    }

    protected Component m_6820_() {
        return this.m_5446_();
    }

    private static boolean canAcceptRecipeOutput(@Nullable Recipe<?> recipe, NonNullList<ItemStack> slots, int count) {
        if (((ItemStack)slots.get(0)).m_41619_() || recipe == null) {
            return false;
        }
        ItemStack itemStack = recipe.m_8043_();
        if (itemStack.m_41619_()) {
            return false;
        }
        ItemStack itemStack2 = (ItemStack)slots.get(2);
        if (itemStack2.m_41619_()) {
            return true;
        }
        if (!itemStack2.m_41656_(itemStack)) {
            return false;
        }
        if (itemStack2.m_41613_() < count && itemStack2.m_41613_() < itemStack2.m_41741_()) {
            return true;
        }
        return itemStack2.m_41613_() < itemStack.m_41741_();
    }

    private static boolean craftRecipe(@Nullable Recipe<?> recipe, NonNullList<ItemStack> slots, int count) {
        if (recipe == null || !FreezerBlockEntity.canAcceptRecipeOutput(recipe, slots, count)) {
            return false;
        }
        ItemStack itemStack = (ItemStack)slots.get(0);
        ItemStack itemStack2 = recipe.m_8043_();
        ItemStack itemStack3 = (ItemStack)slots.get(2);
        if (itemStack2.m_150930_(Items.f_41999_) || itemStack2.m_150930_(Items.f_41980_) || itemStack2.m_150930_(Items.f_42363_)) {
            slots.set(0, (Object)new ItemStack((ItemLike)Items.f_42446_));
        }
        if (itemStack2.m_41720_() == Items.f_42452_) {
            slots.set(0, (Object)new ItemStack((ItemLike)Items.f_42590_));
        }
        if (itemStack3.m_41619_()) {
            slots.set(2, (Object)itemStack2.m_41777_());
        } else if (itemStack3.m_150930_(itemStack2.m_41720_())) {
            itemStack3.m_41769_(1);
        }
        itemStack.m_41774_(1);
        return true;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return this.m_6555_(syncId, inv);
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new FreezerScreenHandler(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FreezerBlockEntity blockEntity) {
        boolean bl = blockEntity.isActive();
        boolean bl2 = false;
        if (blockEntity.isActive()) {
            --blockEntity.fuelTime;
        }
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(1);
        if (blockEntity.isActive() || !itemStack.m_41619_() && !((ItemStack)blockEntity.inventory.get(0)).m_41619_()) {
            Recipe recipe = world.m_7465_().m_44015_(blockEntity.recipeType, (Container)blockEntity, world).orElse(null);
            int i = blockEntity.m_6893_();
            if (!blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                blockEntity.fuelTimeTotal = blockEntity.fuelTime = blockEntity.getFuelTime(itemStack);
                if (blockEntity.isActive()) {
                    bl2 = true;
                    if (!itemStack.m_41619_()) {
                        Item item = itemStack.m_41720_();
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            Item item2 = item.m_41469_();
                            blockEntity.inventory.set(1, (Object)(item2 == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item2)));
                        }
                    }
                }
            }
            if (blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                ++blockEntity.freezeTime;
                if (blockEntity.freezeTime == blockEntity.freezeTimeTotal) {
                    blockEntity.freezeTime = 0;
                    blockEntity.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(world, blockEntity.recipeType, (Container)blockEntity);
                    if (FreezerBlockEntity.craftRecipe(recipe, blockEntity.inventory, i)) {
                        blockEntity.m_6029_(recipe);
                    }
                    bl2 = true;
                }
            } else {
                blockEntity.freezeTime = 0;
            }
        } else if (!blockEntity.isActive() && blockEntity.freezeTime > 0) {
            blockEntity.freezeTime = Mth.m_14045_((int)(blockEntity.freezeTime - 2), (int)0, (int)blockEntity.freezeTimeTotal);
        }
        if (bl != blockEntity.isActive()) {
            bl2 = true;
        }
        if (bl2) {
            FreezerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends FreezerBlockEntity> getFactory() {
        return FreezerBlockEntityImpl.getFactory();
    }
}

