/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PFMBedBlockEntity;
import com.unlikepaladin.pfm.client.PFMBuiltinItemRendererExtension;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleBedBlock
extends BedBlock
implements DyeableFurnitureBlock,
PFMBuiltinItemRendererExtension {
    private static final List<FurnitureBlock> SIMPLE_BEDS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    static final VoxelShape HEAD = Shapes.m_83110_((VoxelShape)SimpleBedBlock.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape)SimpleBedBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0));
    static final VoxelShape HEAD_SOUTH = LogTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, HEAD);
    static final VoxelShape HEAD_EAST = LogTableBlock.rotateShape(Direction.NORTH, Direction.EAST, HEAD);
    static final VoxelShape HEAD_WEST = LogTableBlock.rotateShape(Direction.NORTH, Direction.WEST, HEAD);
    static final VoxelShape FOOT_EAST = Shapes.m_83110_((VoxelShape)SimpleBedBlock.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0), (VoxelShape)SimpleBedBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0));
    static final VoxelShape FOOT_SOUTH = LogTableBlock.rotateShape(Direction.EAST, Direction.SOUTH, FOOT_EAST);
    static final VoxelShape FOOT_WEST = LogTableBlock.rotateShape(Direction.EAST, Direction.WEST, FOOT_EAST);
    static final VoxelShape FOOT_NORTH = LogTableBlock.rotateShape(Direction.EAST, Direction.NORTH, FOOT_EAST);

    public SimpleBedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false)));
        if (this.getClass().isAssignableFrom(SimpleBedBlock.class)) {
            String bedColor = color.m_41065_();
            SIMPLE_BEDS.add(new FurnitureBlock((Block)this, bedColor + "_simple_bed"));
        }
        this.color = color;
    }

    public static Stream<FurnitureBlock> streamSimpleBeds() {
        return SIMPLE_BEDS.stream();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        if (ctx.m_43725_().m_8055_(blockPos2).m_60629_(ctx)) {
            return blockState;
        }
        return null;
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !((state = world.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60734_() instanceof SimpleBedBlock)) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)world)) {
            world.m_7471_(pos, false);
            BlockPos blockPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (world.m_8055_(blockPos).m_60713_((Block)this)) {
                world.m_7471_(blockPos, false);
            }
            world.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.isFree(world, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(reason -> {
            if (reason != null) {
                player.m_5661_(reason.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean isFree(Level world, BlockPos pos) {
        List list = world.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == SimpleBedBlock.getDirectionTowardsOtherPart((BedPart)state.m_61143_((Property)f_49440_), (Direction)state.m_61143_((Property)f_54117_))) {
            if (neighborState.m_60734_() instanceof SimpleBedBlock && neighborState.m_61143_((Property)f_49440_) != state.m_61143_((Property)f_49440_)) {
                return (BlockState)state.m_61124_((Property)f_49441_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_49441_)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.f_46443_ && player.m_7500_() && (bedPart = (BedPart)state.m_61143_((Property)f_49440_)) == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(SimpleBedBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        this.m_142387_(world, player, pos, state);
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
        world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SimpleBedBlock.getBedShape((Direction)state.m_61143_((Property)f_54117_), (BedPart)state.m_61143_((Property)f_49440_), HEAD, FOOT_NORTH, HEAD_EAST, FOOT_EAST, HEAD_WEST, FOOT_WEST, HEAD_SOUTH, FOOT_SOUTH);
    }

    static VoxelShape getBedShape(Direction direction, BedPart bedPart2, VoxelShape head, VoxelShape footNorth, VoxelShape headEast, VoxelShape footEast, VoxelShape headWest, VoxelShape footWest, VoxelShape headSouth, VoxelShape footSouth) {
        switch (direction) {
            case NORTH: {
                if (bedPart2 == BedPart.HEAD) {
                    return head;
                }
                return footNorth;
            }
            case EAST: {
                if (bedPart2 == BedPart.HEAD) {
                    return headEast;
                }
                return footEast;
            }
            case WEST: {
                if (bedPart2 == BedPart.HEAD) {
                    return headWest;
                }
                return footWest;
            }
        }
        if (bedPart2 == BedPart.HEAD) {
            return headSouth;
        }
        return footSouth;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PFMBedBlockEntity(pos, state, this.color);
    }
}

