/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenCounterBlock
extends HorizontalDirectionalBlock {
    private float height = 0.36f;
    private final Block baseBlock;
    protected FurnitureBlock counterFurnitureBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_COUNTERS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_COUNTERS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape STRAIGHT = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape INNER_CORNER = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.m_49796_((double)3.0, (double)1.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0)});
    protected static final VoxelShape OUTER_CORNER = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)13.0), KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)12.0)});
    protected static final VoxelShape LEFT_EDGE = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), KitchenCounterBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape RIGHT_EDGE = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0), KitchenCounterBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenCounterBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape MIDDLE = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape INNER_MIDDLE = Shapes.m_83110_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)KitchenCounterBlock.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape OUTER_MIDDLE = Shapes.m_83124_((VoxelShape)KitchenCounterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE);
    protected static final VoxelShape MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE);
    protected static final VoxelShape MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_MIDDLE);
    protected static final VoxelShape STRAIGHT_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT);
    protected static final VoxelShape STRAIGHT_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT);
    protected static final VoxelShape INNER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER);
    protected static final VoxelShape OUTER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER);
    protected static final VoxelShape LEFT_EDGE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, LEFT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, RIGHT_EDGE);

    public KitchenCounterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        this.counterFurnitureBlock = new FurnitureBlock((Block)this, "kitchen_counter");
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenCounterBlock.class)) {
            WOOD_COUNTERS.add(this.counterFurnitureBlock);
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenCounterBlock.class)) {
            STONE_COUNTERS.add(this.counterFurnitureBlock);
        }
    }

    public static Stream<FurnitureBlock> streamWoodCounters() {
        return WOOD_COUNTERS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneCounters() {
        return STONE_COUNTERS.stream();
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public boolean canConnect(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        return this.isCounter(state) || state.m_60734_() instanceof AbstractFurnaceBlock || state.m_60734_() instanceof AbstractCauldronBlock || KitchenCounterBlock.isCookingForBlockHeadsBlock(state.m_60734_().m_7705_());
    }

    public static boolean isCookingForBlockHeadsBlock(String key) {
        return key.contains("cookingforblockheads") && (key.contains("cooking_table") || key.contains("oven") || key.contains("sink") || key.contains("corner") || key.contains("cabinet") || key.contains("counter"));
    }

    public boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.m_8055_(pos.m_121945_(dir));
        return !this.canConnectToCounter(blockState);
    }

    public boolean canConnectToCounter(BlockState state) {
        return this.isCounter(state) || state.m_60734_() instanceof AbstractFurnaceBlock || state.m_60734_() instanceof AbstractCauldronBlock || KitchenCounterBlock.isCookingForBlockHeadsBlock(state.m_60734_().m_7705_());
    }

    public boolean isCounter(BlockState state) {
        boolean doDifferentCountersConnect = PaladinFurnitureMod.getPFMConfig().doCountersOfDifferentMaterialsConnect() ? state.m_60734_() instanceof KitchenCounterBlock : (state.m_60734_() instanceof KitchenCounterBlock ? this.counterFurnitureBlock.getBaseMaterial() == ((KitchenCounterBlock)state.m_60734_()).counterFurnitureBlock.getBaseMaterial() : false);
        return doDifferentCountersConnect || state.m_60734_() instanceof KitchenWallCounterBlock || state.m_60734_() instanceof KitchenWallDrawerBlock;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        boolean right = this.canConnect(world, pos, ((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
        boolean left = this.canConnect(world, pos, ((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
        BlockState neighborStateFacing = world.m_8055_(pos.m_121945_(direction));
        BlockState neighborStateOpposite = world.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (this.canConnectToCounter(neighborStateFacing) && neighborStateFacing.m_61147_().contains(BlockStateProperties.f_61374_)) {
            Direction direction2 = (Direction)neighborStateFacing.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction2.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && this.isDifferentOrientation(state, world, pos, direction2.m_122424_())) {
                if (direction2 == direction.m_122428_()) {
                    switch (direction) {
                        case NORTH: {
                            return OUTER_CORNER;
                        }
                        case SOUTH: {
                            return OUTER_CORNER_SOUTH;
                        }
                        case EAST: {
                            return OUTER_CORNER_EAST;
                        }
                    }
                    return OUTER_CORNER_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        return OUTER_CORNER_EAST;
                    }
                    case SOUTH: {
                        return OUTER_CORNER_WEST;
                    }
                    case EAST: {
                        return OUTER_CORNER_SOUTH;
                    }
                }
                return OUTER_CORNER;
            }
            return this.getMiddleShape(direction, left, right);
        }
        if (this.canConnectToCounter(neighborStateOpposite) && neighborStateOpposite.m_61147_().contains(BlockStateProperties.f_61374_)) {
            Direction direction3 = neighborStateOpposite.m_60734_() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() : (Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction3.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && this.isDifferentOrientation(state, world, pos, direction3)) {
                if (direction3 == direction.m_122428_()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_CORNER_WEST;
                        }
                        case SOUTH: {
                            return INNER_CORNER_EAST;
                        }
                        case EAST: {
                            return INNER_CORNER;
                        }
                    }
                    return INNER_CORNER_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_CORNER;
                    }
                    case SOUTH: {
                        return INNER_CORNER_SOUTH;
                    }
                    case EAST: {
                        return INNER_CORNER_EAST;
                    }
                }
                return INNER_CORNER_WEST;
            }
            return this.getMiddleShape(direction, left, right);
        }
        return this.getMiddleShape(direction, left, right);
    }

    private VoxelShape getMiddleShape(Direction direction, boolean left, boolean right) {
        if (left && right) {
            switch (direction) {
                case NORTH: {
                    return STRAIGHT;
                }
                case SOUTH: {
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    return STRAIGHT_EAST;
                }
            }
            return STRAIGHT_WEST;
        }
        if (left) {
            switch (direction) {
                case NORTH: {
                    return LEFT_EDGE;
                }
                case SOUTH: {
                    return LEFT_EDGE_SOUTH;
                }
                case EAST: {
                    return LEFT_EDGE_EAST;
                }
            }
            return LEFT_EDGE_WEST;
        }
        if (right) {
            switch (direction) {
                case NORTH: {
                    return RIGHT_EDGE;
                }
                case SOUTH: {
                    return RIGHT_EDGE_SOUTH;
                }
                case EAST: {
                    return RIGHT_EDGE_EAST;
                }
            }
            return RIGHT_EDGE_WEST;
        }
        switch (direction) {
            case NORTH: {
                return STRAIGHT;
            }
            case SOUTH: {
                return STRAIGHT_SOUTH;
            }
            case EAST: {
                return STRAIGHT_EAST;
            }
        }
        return STRAIGHT_WEST;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }
}

