/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.IronFridgeBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> FRIDGES = new ArrayList<FurnitureBlock>();
    private final Supplier<FreezerBlock> freezer;
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.51, (double)0.131, (double)2.609, (double)14.49, (double)1.1, (double)3.609), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), Block.m_49796_((double)0.5, (double)0.0, (double)2.844, (double)15.5, (double)1.0, (double)15.844), Block.m_49796_((double)12.979, (double)4.0, (double)0.027, (double)13.979, (double)15.0, (double)1.027), Block.m_49796_((double)12.979, (double)4.0, (double)0.918, (double)13.979, (double)5.0, (double)2.918), Block.m_49796_((double)12.979, (double)14.0, (double)0.918, (double)13.979, (double)15.0, (double)2.918), Block.m_49796_((double)0.479, (double)1.0, (double)1.933, (double)14.174, (double)16.0, (double)3.033), Block.m_49796_((double)13.814, (double)1.0, (double)2.081, (double)14.814, (double)16.0, (double)3.481)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)0.0, (double)2.0, (double)14.2, (double)16.0, (double)3.0), Block.m_49796_((double)13.84, (double)-0.05, (double)2.15, (double)14.84, (double)16.0, (double)3.55), Block.m_49796_((double)13.0, (double)-0.01, (double)0.09, (double)14.0, (double)15.19, (double)1.09), Block.m_49796_((double)13.0, (double)14.19, (double)1.06, (double)14.0, (double)15.19, (double)3.06)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)16.2, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.979, (double)0.0, (double)0.027, (double)13.979, (double)16.2, (double)1.027), Block.m_49796_((double)0.479, (double)0.0, (double)1.933, (double)14.174, (double)16.2, (double)3.033), Block.m_49796_((double)13.81385, (double)0.0, (double)2.08103, (double)14.81385, (double)16.2, (double)3.48103)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.51, (double)0.13, (double)2.61, (double)14.49, (double)1.1, (double)3.61), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.48563, (double)1.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), Block.m_49796_((double)0.5, (double)0.0, (double)2.84, (double)15.5, (double)1.0, (double)15.84), Block.m_49796_((double)12.98, (double)4.0, (double)0.03, (double)13.98, (double)16.0, (double)1.03), Block.m_49796_((double)12.98, (double)4.0, (double)0.92, (double)13.98, (double)5.0, (double)2.92), Block.m_49796_((double)0.48, (double)1.0, (double)1.93, (double)14.17, (double)16.0, (double)3.03), Block.m_49796_((double)13.81, (double)1.0, (double)2.08, (double)14.81, (double)16.0, (double)3.48)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.98, (double)4.0, (double)0.03, (double)13.98, (double)20.0, (double)1.03), Block.m_49796_((double)12.98, (double)4.0, (double)0.92, (double)13.98, (double)5.0, (double)2.92), Block.m_49796_((double)12.98, (double)18.98, (double)1.0, (double)13.98, (double)19.98, (double)2.9), Block.m_49796_((double)0.5, (double)1.0, (double)1.93, (double)14.78, (double)19.98, (double)3.03)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.979, (double)0.0, (double)0.027, (double)13.979, (double)16.0, (double)1.027), Block.m_49796_((double)12.979, (double)15.984, (double)0.027, (double)13.979, (double)19.984, (double)1.027), Block.m_49796_((double)12.979, (double)18.984, (double)0.996, (double)13.979, (double)19.984, (double)2.896), Block.m_49796_((double)0.479, (double)0.0, (double)1.933, (double)14.174, (double)20.0, (double)3.033), Block.m_49796_((double)13.814, (double)0.0, (double)2.081, (double)14.814, (double)20.0, (double)3.481), Block.m_49796_((double)0.487, (double)0.0, (double)2.62, (double)15.123, (double)21.0, (double)4.013)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)0.0, (double)2.844, (double)15.5, (double)1.0, (double)15.844), Block.m_49796_((double)-1.407, (double)4.0, (double)-10.505, (double)-0.407, (double)15.0, (double)-9.505), Block.m_49796_((double)-0.516, (double)4.0, (double)-10.505, (double)1.484, (double)5.0, (double)-9.505), Block.m_49796_((double)-0.516, (double)14.0, (double)-10.505, (double)1.484, (double)15.0, (double)-9.505), Block.m_49796_((double)0.5, (double)1.0, (double)-10.7, (double)1.6, (double)16.0, (double)3.019), Block.m_49796_((double)0.647, (double)1.0, (double)-11.34, (double)2.047, (double)16.0, (double)-10.34), Block.m_49796_((double)1.688, (double)0.3, (double)2.612, (double)15.116, (double)15.82, (double)4.013), Block.m_49796_((double)1.4, (double)9.5, (double)-10.7, (double)4.4, (double)12.5, (double)2.3), Block.m_49796_((double)1.4, (double)2.0, (double)-10.7, (double)4.4, (double)5.0, (double)2.3)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.425, (double)0.0, (double)3.0, (double)15.495, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.4, (double)9.5, (double)-10.7, (double)4.4, (double)12.5, (double)2.3), Block.m_49796_((double)1.4, (double)2.0, (double)-10.7, (double)4.4, (double)5.0, (double)2.3), Block.m_49796_((double)0.426, (double)0.0, (double)-10.633, (double)1.426, (double)16.0, (double)3.067), Block.m_49796_((double)0.773, (double)0.0, (double)-11.476, (double)1.773, (double)16.0, (double)-10.076), Block.m_49796_((double)-1.481, (double)0.188, (double)-10.433, (double)-0.481, (double)15.188, (double)-9.433), Block.m_49796_((double)-0.512, (double)14.188, (double)-10.433, (double)1.288, (double)15.188, (double)-9.433), Block.m_49796_((double)0.51, (double)-0.037, (double)2.609, (double)15.19, (double)15.931, (double)3.609)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.484, (double)0.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.43, (double)0.0, (double)-10.505, (double)-0.43, (double)16.0, (double)-9.505), Block.m_49796_((double)0.476, (double)0.0, (double)-10.7, (double)1.576, (double)16.0, (double)3.058), Block.m_49796_((double)0.624, (double)0.0, (double)-11.34, (double)2.024, (double)16.0, (double)-10.34), Block.m_49796_((double)1.688, (double)0.0, (double)2.612, (double)15.116, (double)16.0, (double)4.013), Block.m_49796_((double)1.4, (double)9.5, (double)-9.7, (double)4.4, (double)12.5, (double)3.3), Block.m_49796_((double)1.4, (double)2.0, (double)-9.7, (double)4.4, (double)5.0, (double)3.3)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.51, (double)0.131, (double)2.609, (double)15.19, (double)16.1, (double)3.609), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)1.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0), Block.m_49796_((double)0.5, (double)0.0, (double)2.844, (double)15.5, (double)1.0, (double)15.844), Block.m_49796_((double)-1.469, (double)4.0, (double)-10.405, (double)-0.469, (double)16.0, (double)-9.405), Block.m_49796_((double)-0.579, (double)4.0, (double)-10.405, (double)1.421, (double)5.0, (double)-9.405), Block.m_49796_((double)0.437, (double)1.0, (double)-10.6, (double)1.537, (double)16.0, (double)3.095), Block.m_49796_((double)0.585, (double)1.0, (double)-11.24, (double)1.985, (double)16.0, (double)-10.24), Block.m_49796_((double)1.4, (double)9.5, (double)-9.7, (double)4.4, (double)12.5, (double)3.3), Block.m_49796_((double)1.4, (double)2.0, (double)-9.7, (double)4.4, (double)5.0, (double)3.3)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.41, (double)4.0, (double)-10.39, (double)-0.41, (double)19.98, (double)-9.39), Block.m_49796_((double)-0.52, (double)4.0, (double)-10.39, (double)1.48, (double)5.0, (double)-9.39), Block.m_49796_((double)-0.45, (double)18.98, (double)-10.39, (double)1.45, (double)19.98, (double)-9.39), Block.m_49796_((double)0.5, (double)1.0, (double)-11.59, (double)1.48, (double)20.0, (double)3.11), Block.m_49796_((double)0.75, (double)7.7, (double)-10.42, (double)3.75, (double)10.8, (double)2.98), Block.m_49796_((double)0.75, (double)12.2, (double)-10.42, (double)3.75, (double)15.3, (double)2.98)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.415, (double)0.0, (double)-10.391, (double)-0.415, (double)20.0, (double)-9.391), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-0.446, (double)18.984, (double)-10.391, (double)1.454, (double)19.984, (double)-9.391), Block.m_49796_((double)0.491, (double)0.0, (double)-10.591, (double)1.491, (double)20.0, (double)3.109), Block.m_49796_((double)0.634, (double)0.0, (double)-11.221, (double)2.034, (double)20.0, (double)-10.221), Block.m_49796_((double)1.4, (double)9.0, (double)-10.7, (double)4.4, (double)12.0, (double)2.3), Block.m_49796_((double)1.4, (double)2.0, (double)-10.7, (double)4.4, (double)5.0, (double)2.3), Block.m_49796_((double)1.4, (double)15.5, (double)-10.7, (double)4.4, (double)18.5, (double)2.3), Block.m_49796_((double)0.487, (double)0.0, (double)2.62, (double)15.123, (double)21.0, (double)4.013), Block.m_49796_((double)0.5, (double)0.0, (double)3.0, (double)15.5, (double)16.0, (double)16.0)}));
        }
    };

    public FridgeBlock(BlockBehaviour.Properties settings, Supplier<FreezerBlock> freezer) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        FRIDGES.add(new FurnitureBlock((Block)this, "fridge"));
        this.freezer = freezer;
    }

    public static Stream<FurnitureBlock> streamFridges() {
        return FRIDGES.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return super.m_7898_(state, world, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof FridgeBlockEntity) {
            ((FridgeBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122478_() && neighborState.m_60734_() == this ? (neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) ? (BlockState)state.m_61124_((Property)OPEN, (Comparable)((Boolean)neighborState.m_61143_((Property)OPEN))) : state) : state;
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.m_5893_((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.m_36220_(Statistics.FRIDGE_OPENED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60713_((Block)this)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasFreezer;
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        boolean bottom = state.m_60713_(world.m_8055_(pos.m_7494_()).m_60734_());
        boolean top = state.m_60713_(world.m_8055_(pos.m_7495_()).m_60734_());
        boolean bl = hasFreezer = world.m_8055_(pos.m_7494_()).m_60734_() instanceof FreezerBlock && !(world.m_8055_(pos.m_7494_()).m_60734_() instanceof IronFridgeBlock);
        if (top && hasFreezer) {
            if (open) {
                if (!FRIDGE_MIDDLE_FREEZER_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_FREEZER_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_FREEZER_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE_FREEZER.containsKey(dir)) {
                FRIDGE_MIDDLE_FREEZER.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE_FREEZER.get(dir);
        }
        if (top && bottom) {
            if (open) {
                if (!FRIDGE_MIDDLE_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE.containsKey(dir)) {
                FRIDGE_MIDDLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE.get(dir);
        }
        if (bottom) {
            if (open) {
                if (!FRIDGE_BOTTOM_OPEN.containsKey(dir)) {
                    FRIDGE_BOTTOM_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_BOTTOM_OPEN.get(dir);
            }
            if (!FRIDGE_BOTTOM.containsKey(dir)) {
                FRIDGE_BOTTOM.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM.get(Direction.NORTH)));
            }
            return FRIDGE_BOTTOM.get(dir);
        }
        if (top) {
            if (open) {
                if (!FRIDGE_TOP_OPEN.containsKey(dir)) {
                    FRIDGE_TOP_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_TOP_OPEN.get(dir);
            }
            if (!FRIDGE_TOP.containsKey(dir)) {
                FRIDGE_TOP.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP.get(Direction.NORTH)));
            }
            return FRIDGE_TOP.get(dir);
        }
        if (hasFreezer) {
            if (open) {
                if (!FRIDGE_OPEN.containsKey(dir)) {
                    FRIDGE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_OPEN.get(dir);
            }
            if (!FRIDGE.containsKey(dir)) {
                FRIDGE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE.get(Direction.NORTH)));
            }
            return FRIDGE.get(dir);
        }
        if (open) {
            if (!FRIDGE_SINGLE_OPEN.containsKey(dir)) {
                FRIDGE_SINGLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE_OPEN.get(Direction.NORTH)));
            }
            return FRIDGE_SINGLE_OPEN.get(dir);
        }
        if (!FRIDGE_SINGLE.containsKey(dir)) {
            FRIDGE_SINGLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE.get(Direction.NORTH)));
        }
        return FRIDGE_SINGLE.get(dir);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return FridgeBlockEntity.getFactory().m_155267_(pos, state);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

