/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.config.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.forge.PaladinFurnitureModUpdateCheckerImpl;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.Version;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.Nullable;

public class PaladinFurnitureModUpdateChecker {
    private CompletableFuture<UpdateInfo> info;
    private boolean shouldShowUpdateMessage;

    public static File getUpdateFile() {
        Path path = PFMRuntimeResources.getPFMDirectory().resolve("pfmUpdateInfo.json");
        return path.toFile();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static URL getUpdateURL() throws MalformedURLException {
        return PaladinFurnitureModUpdateCheckerImpl.getUpdateURL();
    }

    public void checkForUpdates(PaladinFurnitureModConfig pfmConfig) {
        if (!pfmConfig.shouldCheckForUpdates()) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("[Paladin's Furniture Update Check] Not checking for updates as updater is disabled.");
            this.shouldShowUpdateMessage = false;
            return;
        }
        this.info = CompletableFuture.supplyAsync(() -> {
            block21: {
                try {
                    block20: {
                        UpdateInfo updateInfo;
                        String updateIndex;
                        File updateFile = PaladinFurnitureModUpdateChecker.getUpdateFile();
                        if (DateUtils.isSameDay((Date)new Date(), (Date)new Date(updateFile.lastModified()))) {
                            UpdateInfo updateInfo2;
                            PaladinFurnitureMod.GENERAL_LOGGER.info("[Paladin's Furniture Update Check] Cached update file detected, using that!");
                            try {
                                updateInfo2 = (UpdateInfo)new Gson().fromJson(FileUtils.readFileToString((File)updateFile, (Charset)StandardCharsets.UTF_8), UpdateInfo.class);
                            }
                            catch (JsonSyntaxException | NullPointerException e) {
                                PaladinFurnitureMod.GENERAL_LOGGER.error("[Paladin's Furniture Update Check] Cached file invalid, will delete!", e);
                                Files.delete(updateFile.toPath());
                                return null;
                            }
                            try {
                                if (!Version.getVersion(updateInfo2.semanticVersion)) return null;
                                this.shouldShowUpdateMessage = true;
                                PaladinFurnitureMod.GENERAL_LOGGER.info("[Paladin's Furniture Update Check] New update detected, showing update message!");
                                return updateInfo2;
                            }
                            catch (Exception e) {
                                PaladinFurnitureMod.GENERAL_LOGGER.error("[Paladin's Furniture Update Check] Caught a VersionParsingException while parsing semantic versions!", (Throwable)e);
                            }
                        }
                        InputStream in = PaladinFurnitureModUpdateChecker.getUpdateURL().openStream();
                        try {
                            updateIndex = new JsonParser().parse((Reader)new InputStreamReader(in)).getAsJsonObject().get(PaladinFurnitureModUpdateChecker.getMcVersion()).getAsString();
                        }
                        catch (NullPointerException e) {
                            PaladinFurnitureMod.GENERAL_LOGGER.warn("[Paladin's Furniture Update Check] This version doesn't have an update index, skipping.");
                            UpdateInfo updateInfo3 = null;
                            if (in == null) return updateInfo3;
                            in.close();
                            return updateInfo3;
                        }
                        String json = IOUtils.toString((URL)new URL(updateIndex), (Charset)StandardCharsets.UTF_8);
                        UpdateInfo updateInfo4 = (UpdateInfo)new Gson().fromJson(json, UpdateInfo.class);
                        BufferedWriter writer = new BufferedWriter(new FileWriter(updateFile));
                        writer.write(json);
                        writer.close();
                        try {
                            if (!Version.getVersion(updateInfo4.semanticVersion)) break block20;
                            this.shouldShowUpdateMessage = true;
                            PaladinFurnitureMod.GENERAL_LOGGER.info("[Paladin's Furniture Update Check] New update detected, showing update message!");
                            updateInfo = updateInfo4;
                            if (in == null) return updateInfo;
                        }
                        catch (Exception e) {
                            PaladinFurnitureMod.GENERAL_LOGGER.error("[Paladin's Furniture Update Check] Caught a VersionParsingException while parsing semantic versions!", (Throwable)e);
                            break block21;
                        }
                        in.close();
                        return updateInfo;
                    }
                    PaladinFurnitureMod.GENERAL_LOGGER.info("[Paladin's Furniture Update Check] Is up to date!");
                    return null;
                }
                catch (FileNotFoundException e) {
                    PaladinFurnitureMod.GENERAL_LOGGER.warn("[Paladin's Furniture Update Check] Unable to download " + e.getMessage());
                }
                catch (IOException e) {
                    PaladinFurnitureMod.GENERAL_LOGGER.warn("[Paladin's Furniture Update Check] Failed to get update info!", (Throwable)e);
                }
            }
            PaladinFurnitureMod.GENERAL_LOGGER.warn("[Paladin's Furniture Update Check] Returning null!");
            return null;
        });
    }

    public String getUpdateVersion() {
        if (this.getUpdateInfo() != null) {
            return this.getUpdateInfo().semanticVersion;
        }
        return "null";
    }

    @Nullable
    public UpdateInfo getUpdateInfo() {
        if (this.info != null && this.info.isDone()) {
            try {
                return this.info.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<Component> getUpdateMessage() {
        if (this.shouldShowUpdateMessage) {
            UpdateInfo info = this.getUpdateInfo();
            if (info == null) {
                return Optional.empty();
            }
            String languageCode = Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase(Locale.ROOT);
            String originalText = info.updateInfo.containsKey(languageCode) ? info.updateInfo.get(languageCode) : info.updateInfo.get("en_us");
            String[] textParts = originalText.split("\\{link}");
            if (textParts.length > 1) {
                MutableComponent component1 = Component.m_237113_((String)textParts[0]);
                MutableComponent component2 = Component.m_237113_((String)textParts[1]);
                MutableComponent link = Component.m_237113_((String)info.modHost).m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, info.modDownload)).m_131162_(Boolean.valueOf(true)));
                return Optional.of(component1.m_7220_((Component)link).m_7220_((Component)component2));
            }
            MutableComponent link = Component.m_237113_((String)info.modHost).m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, info.modDownload)).m_131162_(Boolean.valueOf(true)));
            return Optional.of(Component.m_237113_((String)textParts[0]).m_7220_((Component)link));
        }
        return Optional.empty();
    }

    public Optional<Component> getUpdateMessageServer() {
        if (this.shouldShowUpdateMessage) {
            UpdateInfo info = this.getUpdateInfo();
            if (info == null) {
                return Optional.empty();
            }
            String originalText = info.updateInfo.get("en_us");
            String[] textParts = originalText.split("\\{link}");
            if (textParts.length > 1) {
                MutableComponent component1 = Component.m_237113_((String)textParts[0]);
                MutableComponent component2 = Component.m_237113_((String)textParts[1]);
                MutableComponent link = Component.m_237113_((String)info.modHost).m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, info.modDownload)));
                return Optional.of(component1.m_7220_((Component)link).m_7220_((Component)component2));
            }
            MutableComponent link = Component.m_237113_((String)info.modHost).m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, info.modDownload)));
            return Optional.of(Component.m_237113_((String)textParts[0]).m_7220_((Component)link));
        }
        return Optional.empty();
    }

    public Optional<String> getUpdateLink() {
        if (this.shouldShowUpdateMessage) {
            UpdateInfo info = this.getUpdateInfo();
            return Optional.of(info.modDownload);
        }
        return Optional.empty();
    }

    public static String getMcVersion() {
        String version = SharedConstants.m_183709_().getReleaseTarget();
        if (version == null) {
            throw new IllegalStateException("Could not get the current minecraft version!");
        }
        String[] splitVersion = version.split("\\.");
        if (splitVersion.length < 2) {
            throw new IllegalStateException("Could not parse game version \"" + version + "\"");
        }
        String major = splitVersion[0];
        Object minor = splitVersion[1];
        Object bugfix = splitVersion.length < 3 ? "00" : splitVersion[2];
        if (((String)minor).length() == 1) {
            minor = "0" + (String)minor;
        }
        if (((String)bugfix).length() == 1) {
            bugfix = "0" + (String)bugfix;
        }
        return major + (String)minor + (String)bugfix;
    }

    class UpdateInfo {
        public String semanticVersion;
        public Map<String, String> updateInfo;
        public String modHost;
        public String modDownload;

        UpdateInfo() {
        }
    }
}

